/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject;

import org.easysearch.common.inject.BindingProcessor;
import org.easysearch.common.inject.InjectorImpl;
import org.easysearch.common.inject.Key;
import org.easysearch.common.inject.internal.Errors;
import org.easysearch.common.inject.internal.ErrorsException;
import org.easysearch.common.inject.internal.InternalContext;
import org.easysearch.common.inject.internal.InternalFactory;
import org.easysearch.common.inject.internal.ToStringBuilder;
import org.easysearch.common.inject.spi.Dependency;

class FactoryProxy<T>
implements InternalFactory<T>,
BindingProcessor.CreationListener {
    private final InjectorImpl injector;
    private final Key<T> key;
    private final Key<? extends T> targetKey;
    private final Object source;
    private InternalFactory<? extends T> targetFactory;

    FactoryProxy(InjectorImpl injector, Key<T> key, Key<? extends T> targetKey, Object source) {
        this.injector = injector;
        this.key = key;
        this.targetKey = targetKey;
        this.source = source;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.targetFactory = this.injector.getInternalFactory(this.targetKey, errors.withSource(this.source));
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        return this.targetFactory.get(errors.withSource(this.targetKey), context, dependency);
    }

    public String toString() {
        return new ToStringBuilder(FactoryProxy.class).add("key", this.key).add("provider", this.targetFactory).toString();
    }
}

