/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject;

import java.util.HashSet;
import java.util.Set;
import org.easysearch.common.inject.Binder;
import org.easysearch.common.inject.ConstructorInjector;
import org.easysearch.common.inject.Injector;
import org.easysearch.common.inject.InjectorImpl;
import org.easysearch.common.inject.Key;
import org.easysearch.common.inject.Scopes;
import org.easysearch.common.inject.internal.BindingImpl;
import org.easysearch.common.inject.internal.Errors;
import org.easysearch.common.inject.internal.ErrorsException;
import org.easysearch.common.inject.internal.InternalContext;
import org.easysearch.common.inject.internal.InternalFactory;
import org.easysearch.common.inject.internal.Scoping;
import org.easysearch.common.inject.internal.ToStringBuilder;
import org.easysearch.common.inject.spi.BindingTargetVisitor;
import org.easysearch.common.inject.spi.ConstructorBinding;
import org.easysearch.common.inject.spi.Dependency;
import org.easysearch.common.inject.spi.InjectionPoint;

class ConstructorBindingImpl<T>
extends BindingImpl<T>
implements ConstructorBinding<T> {
    private final Factory<T> factory;

    private ConstructorBindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> scopedFactory, Scoping scoping, Factory<T> factory) {
        super(injector, key, source, scopedFactory, scoping);
        this.factory = factory;
    }

    static <T> ConstructorBindingImpl<T> create(InjectorImpl injector, Key<T> key, Object source, Scoping scoping) {
        Factory factoryFactory = new Factory();
        InternalFactory<T> scopedFactory = Scopes.scope(key, injector, factoryFactory, scoping);
        return new ConstructorBindingImpl<T>(injector, key, source, scopedFactory, scoping, factoryFactory);
    }

    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        this.factory.constructorInjector = injector.constructors.get(this.getKey().getTypeLiteral(), errors);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        if (this.factory.constructorInjector == null) {
            throw new IllegalStateException("not initialized");
        }
        return visitor.visit(this);
    }

    @Override
    public InjectionPoint getConstructor() {
        if (this.factory.constructorInjector == null) {
            throw new IllegalStateException("Binding is not ready");
        }
        return this.factory.constructorInjector.getConstructionProxy().getInjectionPoint();
    }

    @Override
    public Set<InjectionPoint> getInjectableMembers() {
        if (this.factory.constructorInjector == null) {
            throw new IllegalStateException("Binding is not ready");
        }
        return this.factory.constructorInjector.getInjectableMembers();
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        HashSet<InjectionPoint> dependencies = new HashSet<InjectionPoint>();
        dependencies.add(this.getConstructor());
        dependencies.addAll(this.getInjectableMembers());
        return Dependency.forInjectionPoints(dependencies);
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ConstructorBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", this.getScoping()).toString();
    }

    private static class Factory<T>
    implements InternalFactory<T> {
        private ConstructorInjector<T> constructorInjector;

        private Factory() {
        }

        @Override
        public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
            if (this.constructorInjector == null) {
                throw new IllegalStateException("Constructor not ready");
            }
            return (T)this.constructorInjector.construct(errors, context, dependency.getKey().getRawType());
        }
    }
}

