/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import org.easysearch.common.geo.GeometryFormat;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.geometry.Geometry;
import org.easysearch.geometry.utils.WellKnownText;

public class WKTGeometryFormat
implements GeometryFormat<Geometry> {
    public static final String NAME = "wkt";
    private final WellKnownText wellKnownTextParser;

    public WKTGeometryFormat(WellKnownText wellKnownTextParser) {
        this.wellKnownTextParser = wellKnownTextParser;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Geometry fromXContent(XContentParser parser) throws IOException, ParseException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.wellKnownTextParser.fromWKT(parser.text());
    }

    @Override
    public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (geometry != null) {
            return builder.value(this.wellKnownTextParser.toWKT(geometry));
        }
        return builder.nullValue();
    }

    public String toXContentAsObject(Geometry geometry) {
        return this.wellKnownTextParser.toWKT(geometry);
    }
}

