/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.geo;

import org.apache.lucene.geo.Point;
import org.apache.lucene.geo.Polygon;
import org.easysearch.geometry.Circle;
import org.easysearch.geometry.Line;
import org.easysearch.geometry.Rectangle;

public class GeoShapeUtils {
    public static Polygon toLucenePolygon(org.easysearch.geometry.Polygon polygon) {
        Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new Polygon(polygon.getHole(i).getY(), polygon.getHole(i).getX(), new Polygon[0]);
        }
        return new Polygon(polygon.getPolygon().getY(), polygon.getPolygon().getX(), holes);
    }

    public static Polygon toLucenePolygon(Rectangle r) {
        return new Polygon(new double[]{r.getMinLat(), r.getMinLat(), r.getMaxLat(), r.getMaxLat(), r.getMinLat()}, new double[]{r.getMinLon(), r.getMaxLon(), r.getMaxLon(), r.getMinLon(), r.getMinLon()}, new Polygon[0]);
    }

    public static org.apache.lucene.geo.Rectangle toLuceneRectangle(Rectangle r) {
        return new org.apache.lucene.geo.Rectangle(r.getMinLat(), r.getMaxLat(), r.getMinLon(), r.getMaxLon());
    }

    public static Point toLucenePoint(org.easysearch.geometry.Point point) {
        return new Point(point.getLat(), point.getLon());
    }

    public static org.apache.lucene.geo.Line toLuceneLine(Line line) {
        return new org.apache.lucene.geo.Line(line.getLats(), line.getLons());
    }

    public static org.apache.lucene.geo.Circle toLuceneCircle(Circle circle) {
        return new org.apache.lucene.geo.Circle(circle.getLat(), circle.getLon(), circle.getRadiusMeters());
    }

    private GeoShapeUtils() {
    }
}

