/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class CompletableContext<T> {
    private final CompletableFuture<T> completableFuture = new CompletableFuture();

    public void addListener(BiConsumer<T, ? super Exception> listener) {
        BiConsumer<Object, Throwable> castThrowable = (v, t) -> {
            if (t == null) {
                listener.accept(v, null);
            } else {
                assert (!(t instanceof Error)) : "Cannot be error";
                listener.accept(v, (Exception)t);
            }
        };
        this.completableFuture.whenComplete(castThrowable);
    }

    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    public boolean isCompletedExceptionally() {
        return this.completableFuture.isCompletedExceptionally();
    }

    public boolean completeExceptionally(Exception ex) {
        return this.completableFuture.completeExceptionally(ex);
    }

    public boolean complete(T value) {
        return this.completableFuture.complete(value);
    }
}

