/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.routing;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.routing.ShardShuffler;
import org.easysearch.common.util.CollectionUtils;

public class RotationShardShuffler
extends ShardShuffler {
    private final AtomicInteger seed;

    public RotationShardShuffler(int seed) {
        this.seed = new AtomicInteger(seed);
    }

    @Override
    public int nextSeed() {
        return this.seed.getAndIncrement();
    }

    @Override
    public List<ShardRouting> shuffle(List<ShardRouting> shards, int seed) {
        return CollectionUtils.rotate(shards, seed);
    }
}

