/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.coordination;

import org.easysearch.cluster.coordination.CoordinationMetadata;
import org.easysearch.cluster.coordination.CoordinationState;
import org.easysearch.cluster.node.DiscoveryNode;

public abstract class ElectionStrategy {
    public static final ElectionStrategy DEFAULT_INSTANCE = new ElectionStrategy(){

        @Override
        protected boolean satisfiesAdditionalQuorumConstraints(DiscoveryNode localNode, long localCurrentTerm, long localAcceptedTerm, long localAcceptedVersion, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration, CoordinationState.VoteCollection joinVotes) {
            return true;
        }
    };

    protected ElectionStrategy() {
    }

    public final boolean isElectionQuorum(DiscoveryNode localNode, long localCurrentTerm, long localAcceptedTerm, long localAcceptedVersion, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration, CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration, CoordinationState.VoteCollection joinVotes) {
        return joinVotes.isQuorum(lastCommittedConfiguration) && joinVotes.isQuorum(lastAcceptedConfiguration) && this.satisfiesAdditionalQuorumConstraints(localNode, localCurrentTerm, localAcceptedTerm, localAcceptedVersion, lastCommittedConfiguration, lastAcceptedConfiguration, joinVotes);
    }

    protected abstract boolean satisfiesAdditionalQuorumConstraints(DiscoveryNode var1, long var2, long var4, long var6, CoordinationMetadata.VotingConfiguration var8, CoordinationMetadata.VotingConfiguration var9, CoordinationState.VoteCollection var10);
}

