/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.watcher;

import java.io.IOException;
import java.util.Map;
import org.easysearch.EasysearchException;
import org.easysearch.common.ParseField;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentFactory;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.common.xcontent.XContentUtils;

public class ExecuteWatchResponse {
    public static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
    public static final ParseField WATCH_FIELD = new ParseField("watch_record", new String[0]);
    private String recordId;
    private BytesReference contentSource;
    private Map<String, Object> data;
    private static final ConstructingObjectParser<ExecuteWatchResponse, Void> PARSER = new ConstructingObjectParser("x_pack_execute_watch_response", true, fields -> new ExecuteWatchResponse((String)fields[0], (BytesReference)fields[1]));

    public ExecuteWatchResponse() {
    }

    public ExecuteWatchResponse(String recordId, BytesReference contentSource) {
        this.recordId = recordId;
        this.contentSource = contentSource;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public BytesReference getRecord() {
        return this.contentSource;
    }

    public Map<String, Object> getRecordAsMap() {
        if (this.data == null) {
            try (StreamInput stream = this.contentSource.streamInput();
                 XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, null, stream);){
                this.data = (Map)XContentUtils.readValue(parser, parser.nextToken());
            }
            catch (IOException ex) {
                throw new EasysearchException("failed to read value", (Throwable)ex, new Object[0]);
            }
        }
        return this.data;
    }

    public static ExecuteWatchResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static BytesReference readBytesReference(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ExecuteWatchResponse.readBytesReference(p), WATCH_FIELD);
    }
}

