/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security.user.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.easysearch.client.security.user.User;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;

public class UserJsonParser {
    public static Set<User> parseUsers(XContentParser jsonParser) throws IOException, IllegalArgumentException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, jsonParser.nextToken(), jsonParser);
        HashSet<User> users = new HashSet<User>();
        while ((token = jsonParser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, jsonParser);
            String username = jsonParser.currentName();
            jsonParser.nextToken();
            String hash = "";
            List<String> roles = new ArrayList<String>();
            List<String> externalRoles = new ArrayList<String>();
            Map<String, Object> attributes = new HashMap<String, Object>();
            boolean reserved = false;
            boolean hidden = false;
            boolean isStatic = false;
            while (jsonParser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = jsonParser.currentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "hash": {
                        hash = jsonParser.text();
                        break;
                    }
                    case "roles": {
                        roles = UserJsonParser.parseStringArray(jsonParser);
                        break;
                    }
                    case "external_roles": {
                        externalRoles = UserJsonParser.parseStringArray(jsonParser);
                        break;
                    }
                    case "attributes": {
                        attributes = UserJsonParser.parseAttributes(jsonParser);
                        break;
                    }
                    case "reserved": {
                        reserved = jsonParser.booleanValue();
                        break;
                    }
                    case "hidden": {
                        hidden = jsonParser.booleanValue();
                        break;
                    }
                    case "static": {
                        isStatic = jsonParser.booleanValue();
                        break;
                    }
                }
            }
            User user = new User(username, hash, roles, externalRoles, attributes, reserved, hidden, isStatic);
            users.add(user);
        }
        return users;
    }

    private static List<String> parseStringArray(XContentParser jsonParser) throws IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        while (jsonParser.nextToken() != XContentParser.Token.END_ARRAY) {
            stringList.add(jsonParser.text());
        }
        return stringList;
    }

    private static Map<String, Object> parseAttributes(XContentParser jsonParser) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        while (jsonParser.nextToken() != XContentParser.Token.END_OBJECT) {
            String key = jsonParser.currentName();
            jsonParser.nextToken();
            attributes.put(key, jsonParser.text());
        }
        return attributes;
    }
}

