/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security.user.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.easysearch.client.security.user.privileges.Privilege;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentParserUtils;

public class PrivilegeJsonParser {
    public static Set<Privilege> parsePrivileges(XContentParser jsonParser) throws IOException, IllegalArgumentException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, jsonParser.nextToken(), jsonParser);
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        while ((token = jsonParser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, jsonParser);
            String name = jsonParser.currentName();
            jsonParser.nextToken();
            List<String> actions = new ArrayList<String>();
            boolean reserved = false;
            boolean hidden = false;
            boolean _static = false;
            String description = null;
            String type = null;
            while (jsonParser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = jsonParser.currentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "privileges": {
                        actions = PrivilegeJsonParser.parseStringArray(jsonParser);
                        break;
                    }
                    case "reserved": {
                        reserved = jsonParser.booleanValue();
                        break;
                    }
                    case "hidden": {
                        hidden = jsonParser.booleanValue();
                        break;
                    }
                    case "static": {
                        _static = jsonParser.booleanValue();
                        break;
                    }
                    case "description": {
                        description = jsonParser.text();
                    }
                    case "type": {
                        type = jsonParser.text();
                        break;
                    }
                }
            }
            Privilege privilege = new Privilege(name, reserved, hidden, _static, actions, type, description);
            privileges.add(privilege);
        }
        return privileges;
    }

    private static List<String> parseStringArray(XContentParser jsonParser) throws IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        while (jsonParser.nextToken() != XContentParser.Token.END_ARRAY) {
            stringList.add(jsonParser.text());
        }
        return stringList;
    }
}

