/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class User {
    @JsonIgnore
    private final String name;
    private String hash;
    private boolean reserved;
    private boolean hidden;
    @JsonProperty(value="static")
    private boolean _static;
    private final List<String> roles;
    private final List<String> external_roles;
    private final Map<String, Object> attributes;

    public User(String username, List<String> roles, List<String> external_roles, Map<String, Object> attributes) {
        this(username, null, roles, external_roles, attributes, false, false, false);
    }

    public User(String name, String hash, List<String> roles, List<String> external_roles, Map<String, Object> attributes, boolean reserved, boolean hidden, boolean _static) {
        this.name = Objects.requireNonNull(name, "`name` is required, cannot be null");
        this.roles = Objects.requireNonNull(roles, "`roles` is required, cannot be null. Pass an empty Collection instead.");
        this.hash = hash;
        this.external_roles = external_roles;
        this.attributes = attributes;
        this.reserved = reserved;
        this.hidden = hidden;
        this._static = _static;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getExternal_roles() {
        return this.external_roles;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean is_static() {
        return this._static;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.reserved == user.reserved && this.hidden == user.hidden && this._static == user._static && this.name.equals(user.name) && this.hash.equals(this.hash) && this.roles.equals(user.roles) && Objects.equals(this.external_roles, user.external_roles) && Objects.equals(this.attributes, user.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hash, this.roles, this.external_roles, this.attributes, this.reserved, this.hidden, this._static);
    }
}

