/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.rollup.job.config;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.easysearch.client.Validatable;
import org.easysearch.client.ValidationException;
import org.easysearch.client.rollup.job.config.DateHistogramGroupConfig;
import org.easysearch.client.rollup.job.config.HistogramGroupConfig;
import org.easysearch.client.rollup.job.config.TermsGroupConfig;
import org.easysearch.common.Nullable;
import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

public class GroupConfig
implements Validatable,
ToXContentObject {
    static final String NAME = "groups";
    private static final ConstructingObjectParser<GroupConfig, Void> PARSER = new ConstructingObjectParser("groups", true, args -> new GroupConfig((DateHistogramGroupConfig)args[0], (HistogramGroupConfig)args[1], (TermsGroupConfig)args[2]));
    private final DateHistogramGroupConfig dateHistogram;
    @Nullable
    private final HistogramGroupConfig histogram;
    @Nullable
    private final TermsGroupConfig terms;

    public GroupConfig(DateHistogramGroupConfig dateHistogram) {
        this(dateHistogram, null, null);
    }

    public GroupConfig(DateHistogramGroupConfig dateHistogram, @Nullable HistogramGroupConfig histogram, @Nullable TermsGroupConfig terms) {
        this.dateHistogram = dateHistogram;
        this.histogram = histogram;
        this.terms = terms;
    }

    @Override
    public Optional<ValidationException> validate() {
        Optional<ValidationException> termsValidationErrors;
        Optional<ValidationException> histogramValidationErrors;
        ValidationException validationException = new ValidationException();
        if (this.dateHistogram != null) {
            Optional<ValidationException> dateHistogramValidationErrors = this.dateHistogram.validate();
            if (dateHistogramValidationErrors != null && dateHistogramValidationErrors.isPresent()) {
                validationException.addValidationErrors(dateHistogramValidationErrors.get());
            }
        } else {
            validationException.addValidationError("Date histogram must not be null");
        }
        if (this.histogram != null && (histogramValidationErrors = this.histogram.validate()) != null && histogramValidationErrors.isPresent()) {
            validationException.addValidationErrors(histogramValidationErrors.get());
        }
        if (this.terms != null && (termsValidationErrors = this.terms.validate()) != null && termsValidationErrors.isPresent()) {
            validationException.addValidationErrors(termsValidationErrors.get());
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public DateHistogramGroupConfig getDateHistogram() {
        return this.dateHistogram;
    }

    @Nullable
    public HistogramGroupConfig getHistogram() {
        return this.histogram;
    }

    @Nullable
    public TermsGroupConfig getTerms() {
        return this.terms;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("date_histogram", this.dateHistogram);
        if (this.histogram != null) {
            builder.field("histogram", this.histogram);
        }
        if (this.terms != null) {
            builder.field("terms", this.terms);
        }
        return builder.endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GroupConfig that = (GroupConfig)other;
        return Objects.equals(this.dateHistogram, that.dateHistogram) && Objects.equals(this.histogram, that.histogram) && Objects.equals(this.terms, that.terms);
    }

    public int hashCode() {
        return Objects.hash(this.dateHistogram, this.histogram, this.terms);
    }

    public static GroupConfig fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DateHistogramGroupConfig.fromXContent(p), new ParseField("date_histogram", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> HistogramGroupConfig.fromXContent(p), new ParseField("histogram", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TermsGroupConfig.fromXContent(p), new ParseField("terms", new String[0]));
    }
}

