/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.node;

import java.util.Map;
import java.util.function.Supplier;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionResponse;
import org.easysearch.action.ActionType;
import org.easysearch.action.support.TransportAction;
import org.easysearch.client.Client;
import org.easysearch.client.support.AbstractClient;
import org.easysearch.common.io.stream.NamedWriteableRegistry;
import org.easysearch.common.settings.Settings;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskListener;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.RemoteClusterService;

public class NodeClient
extends AbstractClient {
    private Map<ActionType, TransportAction> actions;
    private Supplier<String> localNodeId;
    private RemoteClusterService remoteClusterService;
    private NamedWriteableRegistry namedWriteableRegistry;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<ActionType, TransportAction> actions, Supplier<String> localNodeId, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        this.actions = actions;
        this.localNodeId = localNodeId;
        this.remoteClusterService = remoteClusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public void close() {
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executeLocally(action, request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, TaskListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public String getLocalNodeId() {
        return this.localNodeId.get();
    }

    private <Request extends ActionRequest, Response extends ActionResponse> TransportAction<Request, Response> transportAction(ActionType<Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }

    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }
}

