/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client;

import java.io.IOException;
import org.easysearch.client.Request;
import org.easysearch.client.RequestConverters;
import org.easysearch.client.security.ChangePasswordRequest;
import org.easysearch.client.security.DeletePrivilegesRequest;
import org.easysearch.client.security.DeleteRoleMappingRequest;
import org.easysearch.client.security.DeleteRoleRequest;
import org.easysearch.client.security.DeleteUserRequest;
import org.easysearch.client.security.GetAccountRequest;
import org.easysearch.client.security.GetPrivilegesRequest;
import org.easysearch.client.security.GetRoleMappingsRequest;
import org.easysearch.client.security.GetRolesRequest;
import org.easysearch.client.security.GetUsersRequest;
import org.easysearch.client.security.PutPrivilegeRequest;
import org.easysearch.client.security.PutRoleMappingRequest;
import org.easysearch.client.security.PutRoleRequest;
import org.easysearch.client.security.PutUserRequest;
import org.easysearch.common.Strings;

final class SecurityRequestConverters {
    private SecurityRequestConverters() {
    }

    static Request changePassword(ChangePasswordRequest changePasswordRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/account").build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(changePasswordRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request getUsers(GetUsersRequest getUsersRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/user");
        if (getUsersRequest.getUsernames().size() > 0) {
            builder.addPathPart(Strings.collectionToCommaDelimitedString(getUsersRequest.getUsernames()));
        }
        return new Request("GET", builder.build());
    }

    static Request getAccount(GetAccountRequest getAccountRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/account");
        return new Request("GET", builder.build());
    }

    static Request putUser(PutUserRequest putUserRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/user").addPathPart(putUserRequest.getUser().getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putUserRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request deleteUser(DeleteUserRequest deleteUserRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security", "user").addPathPart(deleteUserRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request putRoleMapping(PutRoleMappingRequest putRoleMappingRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role_mapping").addPathPart(putRoleMappingRequest.getRoleMapping().getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putRoleMappingRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request getRoleMappings(GetRoleMappingsRequest getRoleMappingRequest) throws IOException {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder();
        builder.addPathPartAsIs("_security/role_mapping");
        if (getRoleMappingRequest.getRoleMappingNames().size() > 0) {
            builder.addPathPart(Strings.collectionToCommaDelimitedString(getRoleMappingRequest.getRoleMappingNames()));
        }
        return new Request("GET", builder.build());
    }

    static Request deleteRoleMapping(DeleteRoleMappingRequest deleteRoleMappingRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role_mapping").addPathPart(deleteRoleMappingRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request deleteRole(DeleteRoleRequest deleteRoleRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role").addPathPart(deleteRoleRequest.getName()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request getRoles(GetRolesRequest getRolesRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder();
        builder.addPathPartAsIs("_security/role");
        if (getRolesRequest.getRoleNames().size() > 0) {
            builder.addPathPart(Strings.collectionToCommaDelimitedString(getRolesRequest.getRoleNames()));
        }
        return new Request("GET", builder.build());
    }

    static Request getPrivileges(GetPrivilegesRequest getPrivilegesRequest) {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/privilege");
        if (getPrivilegesRequest.getPrivilegeNames().size() > 0) {
            builder.addPathPart(Strings.collectionToCommaDelimitedString(getPrivilegesRequest.getPrivilegeNames()));
        }
        return new Request("GET", builder.build());
    }

    static Request putPrivileges(PutPrivilegeRequest putPrivilegesRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/privilege").addPathPart(putPrivilegesRequest.getPrivilege().getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putPrivilegesRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request deletePrivileges(DeletePrivilegesRequest deletePrivilegeRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/privilege").addPathPart(deletePrivilegeRequest.getPrivilege()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }

    static Request putRole(PutRoleRequest putRoleRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_security/role").addPathPart(putRoleRequest.getRole().getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putRoleRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        RequestConverters.Params params = new RequestConverters.Params();
        request.addParameters(params.asMap());
        return request;
    }
}

