/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.termvectors;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.RoutingMissingException;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.single.shard.TransportSingleShardAction;
import org.easysearch.action.termvectors.TermVectorsRequest;
import org.easysearch.action.termvectors.TermVectorsResponse;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.routing.GroupShardsIterator;
import org.easysearch.cluster.routing.ShardIterator;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.index.IndexService;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.ShardId;
import org.easysearch.index.termvectors.TermVectorsService;
import org.easysearch.indices.IndicesService;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportTermVectorsAction
extends TransportSingleShardAction<TermVectorsRequest, TermVectorsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportTermVectorsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/tv", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, TermVectorsRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        if (((TermVectorsRequest)request.request()).doc() != null && ((TermVectorsRequest)request.request()).routing() == null) {
            GroupShardsIterator<ShardIterator> groupShardsIter = this.clusterService.operationRouting().searchShards(state, new String[]{request.concreteIndex()}, null, ((TermVectorsRequest)request.request()).preference());
            return groupShardsIter.iterator().next();
        }
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((TermVectorsRequest)request.request()).id(), ((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).preference());
    }

    @Override
    protected boolean resolveIndex(TermVectorsRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((TermVectorsRequest)request.request()).routing(state.metadata().resolveIndexRouting(((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).index()));
        if (((TermVectorsRequest)request.request()).routing() == null && state.getMetadata().routingRequired(request.concreteIndex())) {
            throw new RoutingMissingException(request.concreteIndex(), ((TermVectorsRequest)request.request()).type(), ((TermVectorsRequest)request.request()).id());
        }
    }

    @Override
    protected void asyncShardOperation(TermVectorsRequest request, ShardId shardId, ActionListener<TermVectorsResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation(request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected TermVectorsResponse shardOperation(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        return TermVectorsService.getTermVectors(indexShard, request);
    }

    @Override
    protected Writeable.Reader<TermVectorsResponse> getResponseReader() {
        return TermVectorsResponse::new;
    }

    @Override
    protected String getExecutor(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

