/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.support;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.support.ActiveShardCount;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.ClusterStateObserver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.node.NodeClosedException;
import org.easysearch.threadpool.ThreadPool;

public class ActiveShardsObserver {
    private static final Logger logger = LogManager.getLogger(ActiveShardsObserver.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public ActiveShardsObserver(ClusterService clusterService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public void waitForActiveShards(final String[] indexNames, ActiveShardCount activeShardCount, TimeValue timeout, final Consumer<Boolean> onResult, final Consumer<Exception> onFailure) {
        if (activeShardCount == ActiveShardCount.NONE) {
            onResult.accept(true);
            return;
        }
        ClusterState state = this.clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService, null, logger, this.threadPool.getThreadContext());
        if (activeShardCount.enoughShardsActive(state, indexNames)) {
            onResult.accept(true);
        } else {
            Predicate<ClusterState> shardsAllocatedPredicate = newState -> activeShardCount.enoughShardsActive((ClusterState)newState, indexNames);
            ClusterStateObserver.Listener observerListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    onResult.accept(true);
                }

                @Override
                public void onClusterServiceClose() {
                    logger.debug("[{}] cluster service closed while waiting for enough shards to be started.", (Object)Arrays.toString(indexNames));
                    onFailure.accept(new NodeClosedException(ActiveShardsObserver.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    onResult.accept(false);
                }
            };
            observer.waitForNextChange(observerListener, shardsAllocatedPredicate, timeout);
        }
    }
}

