/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.easysearch.action.ActionListener;
import org.easysearch.action.search.ParsedScrollId;
import org.easysearch.action.search.SearchActionListener;
import org.easysearch.action.search.SearchPhase;
import org.easysearch.action.search.SearchPhaseController;
import org.easysearch.action.search.SearchResponse;
import org.easysearch.action.search.SearchScrollAsyncAction;
import org.easysearch.action.search.SearchScrollRequest;
import org.easysearch.action.search.SearchTask;
import org.easysearch.action.search.SearchTransportService;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.util.concurrent.AtomicArray;
import org.easysearch.search.fetch.QueryFetchSearchResult;
import org.easysearch.search.fetch.ScrollQueryFetchSearchResult;
import org.easysearch.search.internal.InternalScrollSearchRequest;
import org.easysearch.transport.Transport;

final class SearchScrollQueryAndFetchAsyncAction
extends SearchScrollAsyncAction<ScrollQueryFetchSearchResult> {
    private final SearchTask task;
    private final AtomicArray<QueryFetchSearchResult> queryFetchResults;

    SearchScrollQueryAndFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        super(scrollId, logger, clusterService.state().nodes(), listener, searchPhaseController, request, searchTransportService);
        this.task = task;
        this.queryFetchResults = new AtomicArray(scrollId.getContext().length);
    }

    @Override
    protected void executeInitialPhase(Transport.Connection connection, InternalScrollSearchRequest internalRequest, SearchActionListener<ScrollQueryFetchSearchResult> searchActionListener) {
        this.searchTransportService.sendExecuteScrollFetch(connection, internalRequest, this.task, searchActionListener);
    }

    @Override
    protected SearchPhase moveToNextPhase(BiFunction<String, String, DiscoveryNode> clusterNodeLookup) {
        return this.sendResponsePhase(this.searchPhaseController.reducedScrollQueryPhase(this.queryFetchResults.asList()), this.queryFetchResults);
    }

    @Override
    protected void onFirstPhaseResult(int shardId, ScrollQueryFetchSearchResult result) {
        this.queryFetchResults.setOnce(shardId, result.result());
    }
}

