/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.resync;

import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.action.ActionListener;
import org.easysearch.action.resync.ResyncReplicationRequest;
import org.easysearch.action.resync.ResyncReplicationResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.replication.ReplicationOperation;
import org.easysearch.action.support.replication.ReplicationResponse;
import org.easysearch.action.support.replication.TransportReplicationAction;
import org.easysearch.action.support.replication.TransportWriteAction;
import org.easysearch.cluster.action.shard.ShardStateAction;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.settings.Settings;
import org.easysearch.index.IndexingPressure;
import org.easysearch.index.engine.Engine;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.PrimaryReplicaSyncer;
import org.easysearch.index.translog.Translog;
import org.easysearch.indices.IndicesService;
import org.easysearch.indices.SystemIndices;
import org.easysearch.tasks.Task;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportException;
import org.easysearch.transport.TransportResponseHandler;
import org.easysearch.transport.TransportService;

public class TransportResyncReplicationAction
extends TransportWriteAction<ResyncReplicationRequest, ResyncReplicationRequest, ResyncReplicationResponse>
implements PrimaryReplicaSyncer.SyncAction {
    private static String ACTION_NAME = "internal:index/seq_no/resync";
    private static final Function<IndexShard, String> EXECUTOR_NAME_FUNCTION = shard -> {
        if (shard.indexSettings().getIndexMetadata().isSystem()) {
            return "system_write";
        }
        return "write";
    };

    @Inject
    public TransportResyncReplicationAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, ResyncReplicationRequest::new, ResyncReplicationRequest::new, EXECUTOR_NAME_FUNCTION, true, indexingPressure, systemIndices);
    }

    @Override
    protected void doExecute(Task parentTask, ResyncReplicationRequest request, ActionListener<ResyncReplicationResponse> listener) {
        assert (false) : "use TransportResyncReplicationAction#sync";
    }

    @Override
    protected ResyncReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ResyncReplicationResponse(in);
    }

    @Override
    protected ReplicationOperation.Replicas newReplicasProxy() {
        return new ResyncActionReplicasProxy();
    }

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected void dispatchedShardOperationOnPrimary(ResyncReplicationRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> new TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>(TransportResyncReplicationAction.performOnPrimary(request), new ResyncReplicationResponse(), null, null, primary, this.logger));
    }

    @Override
    protected long primaryOperationSize(ResyncReplicationRequest request) {
        return Stream.of(request.getOperations()).mapToLong(Translog.Operation::estimateSize).sum();
    }

    public static ResyncReplicationRequest performOnPrimary(ResyncReplicationRequest request) {
        return request;
    }

    @Override
    protected void dispatchedShardOperationOnReplica(ResyncReplicationRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            Translog.Location location = TransportResyncReplicationAction.performOnReplica(request, replica);
            return new TransportWriteAction.WriteReplicaResult<ResyncReplicationRequest>(request, location, null, replica, this.logger);
        });
    }

    @Override
    protected long replicaOperationSize(ResyncReplicationRequest request) {
        return Stream.of(request.getOperations()).mapToLong(Translog.Operation::estimateSize).sum();
    }

    public static Translog.Location performOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        replica.updateMaxUnsafeAutoIdTimestamp(request.getMaxSeenAutoIdTimestampOnPrimary());
        for (Translog.Operation operation : request.getOperations()) {
            Engine.Result operationResult = replica.applyTranslogOperation(operation, Engine.Operation.Origin.REPLICA);
            if (operationResult.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + operationResult.getRequiredMappingUpdate());
            }
            location = TransportResyncReplicationAction.syncOperationResultOrThrow(operationResult, location);
        }
        if (request.getTrimAboveSeqNo() != -2L) {
            replica.trimOperationOfPreviousPrimaryTerms(request.getTrimAboveSeqNo());
        }
        return location;
    }

    @Override
    public void sync(ResyncReplicationRequest request, Task parentTask, String primaryAllocationId, long primaryTerm, final ActionListener<ResyncReplicationResponse> listener) {
        this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<ResyncReplicationRequest>(request, primaryAllocationId, primaryTerm), parentTask, this.transportOptions, new TransportResponseHandler<ResyncReplicationResponse>(){

            @Override
            public ResyncReplicationResponse read(StreamInput in) throws IOException {
                return TransportResyncReplicationAction.this.newResponseInstance(in);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public void handleResponse(ResyncReplicationResponse response) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                for (int i = 0; i < failures.length; ++i) {
                    ReplicationResponse.ShardInfo.Failure f = failures[i];
                    TransportResyncReplicationAction.this.logger.info((Message)new ParameterizedMessage("{} primary-replica resync to replica on node [{}] failed", (Object)f.fullShardId(), (Object)f.nodeId()), f.getCause());
                }
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }
        });
    }

    class ResyncActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        ResyncActionReplicasProxy() {
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            TransportResyncReplicationAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, false, message, exception, listener);
        }
    }
}

