/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.fieldcaps;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.easysearch.action.ActionResponse;
import org.easysearch.action.fieldcaps.IndexFieldCapabilities;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;

public class FieldCapabilitiesIndexResponse
extends ActionResponse
implements Writeable {
    private final String indexName;
    private final Map<String, IndexFieldCapabilities> responseMap;
    private final boolean canMatch;

    FieldCapabilitiesIndexResponse(String indexName, Map<String, IndexFieldCapabilities> responseMap, boolean canMatch) {
        this.indexName = indexName;
        this.responseMap = responseMap;
        this.canMatch = canMatch;
    }

    FieldCapabilitiesIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.indexName = in.readString();
        this.responseMap = in.readMap(StreamInput::readString, IndexFieldCapabilities::new);
        this.canMatch = in.readBoolean();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean canMatch() {
        return this.canMatch;
    }

    public Map<String, IndexFieldCapabilities> get() {
        return this.responseMap;
    }

    public IndexFieldCapabilities getField(String field) {
        return this.responseMap.get(field);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeMap(this.responseMap, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
        out.writeBoolean(this.canMatch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesIndexResponse that = (FieldCapabilitiesIndexResponse)o;
        return this.canMatch == that.canMatch && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.responseMap, that.responseMap);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.responseMap, this.canMatch);
    }
}

