/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.easysearch.action.admin.indices.stats.CommonStats;
import org.easysearch.action.admin.indices.stats.IndexShardStats;
import org.easysearch.action.admin.indices.stats.IndexStats;
import org.easysearch.action.admin.indices.stats.ShardStats;
import org.easysearch.action.support.DefaultShardOperationFailedException;
import org.easysearch.action.support.broadcast.BroadcastResponse;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.index.Index;

public class IndicesStatsResponse
extends BroadcastResponse {
    private ShardStats[] shards;
    private Map<ShardRouting, ShardStats> shardStatsMap;
    private Map<String, IndexStats> indicesStats;
    private CommonStats total = null;
    private CommonStats primary = null;

    IndicesStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.shards = in.readArray(ShardStats::new, ShardStats[]::new);
    }

    IndicesStatsResponse(ShardStats[] shards, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public Map<ShardRouting, ShardStats> asMap() {
        if (this.shardStatsMap == null) {
            HashMap<ShardRouting, ShardStats> shardStatsMap = new HashMap<ShardRouting, ShardStats>();
            for (ShardStats ss : this.shards) {
                shardStatsMap.put(ss.getShardRouting(), ss);
            }
            this.shardStatsMap = Collections.unmodifiableMap(shardStatsMap);
        }
        return this.shardStatsMap;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public ShardStats getAt(int position) {
        return this.shards[position];
    }

    public IndexStats getIndex(String index) {
        return this.getIndices().get(index);
    }

    public Map<String, IndexStats> getIndices() {
        if (this.indicesStats != null) {
            return this.indicesStats;
        }
        HashMap<String, IndexStats.IndexStatsBuilder> indexToIndexStatsBuilder = new HashMap<String, IndexStats.IndexStatsBuilder>();
        for (ShardStats shard : this.shards) {
            Index index = shard.getShardRouting().index();
            IndexStats.IndexStatsBuilder indexStatsBuilder = indexToIndexStatsBuilder.computeIfAbsent(index.getName(), k -> new IndexStats.IndexStatsBuilder((String)k, index.getUUID()));
            indexStatsBuilder.add(shard);
        }
        this.indicesStats = indexToIndexStatsBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IndexStats.IndexStatsBuilder)entry.getValue()).build()));
        return this.indicesStats;
    }

    public CommonStats getTotal() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.getStats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats getPrimaries() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.getShardRouting().primary()) continue;
            stats.add(shard.getStats());
        }
        this.primary = stats;
        return stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(this.shards);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean isLevelValid;
        String level = params.param("level", "indices");
        boolean bl = isLevelValid = "cluster".equalsIgnoreCase(level) || "indices".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level);
        if (!isLevelValid) {
            throw new IllegalArgumentException("level parameter must be one of [cluster] or [indices] or [shards] but was [" + level + "]");
        }
        builder.startObject("_all");
        builder.startObject("primaries");
        this.getPrimaries().toXContent(builder, params);
        builder.endObject();
        builder.startObject("total");
        this.getTotal().toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        if ("indices".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level)) {
            builder.startObject("indices");
            for (IndexStats indexStats : this.getIndices().values()) {
                builder.startObject(indexStats.getIndex());
                builder.field("uuid", indexStats.getUuid());
                builder.startObject("primaries");
                indexStats.getPrimaries().toXContent(builder, params);
                builder.endObject();
                builder.startObject("total");
                indexStats.getTotal().toXContent(builder, params);
                builder.endObject();
                if ("shards".equalsIgnoreCase(level)) {
                    builder.startObject("shards");
                    for (IndexShardStats indexShardStats : indexStats) {
                        builder.startArray(Integer.toString(indexShardStats.getShardId().id()));
                        for (ShardStats shardStats : indexShardStats) {
                            builder.startObject();
                            shardStats.toXContent(builder, params);
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";

        Fields() {
        }
    }
}

