/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.easysearch.action.admin.indices.stats.FieldUsageTrackerRequest;
import org.easysearch.action.support.broadcast.BroadcastShardRequest;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.index.shard.ShardId;
import org.easysearch.tasks.CancellableTask;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;

public class FieldUsageShardRequest
extends BroadcastShardRequest {
    private final String[] fields;

    FieldUsageShardRequest(ShardId shardId, FieldUsageTrackerRequest request) {
        super(shardId, request);
        this.fields = request.fields();
    }

    FieldUsageShardRequest(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.fields);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return FieldUsageShardRequest.this.getDescription();
            }
        };
    }

    @Override
    public String getDescription() {
        return "get field usage for shard: [" + this.shardId() + "], fields: " + Arrays.toString(this.fields);
    }

    public String[] fields() {
        return this.fields;
    }
}

