/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.readonly;

import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.readonly.AddIndexBlockClusterStateUpdateRequest;
import org.easysearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.easysearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.DestructiveOperations;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.metadata.MetadataIndexStateService;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.index.Index;
import org.easysearch.tasks.Task;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportAddIndexBlockAction
extends TransportMasterNodeAction<AddIndexBlockRequest, AddIndexBlockResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAddIndexBlockAction.class);
    private final MetadataIndexStateService indexStateService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportAddIndexBlockAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexStateService indexStateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super("indices:admin/block/add", transportService, clusterService, threadPool, actionFilters, AddIndexBlockRequest::new, indexNameExpressionResolver);
        this.indexStateService = indexStateService;
        this.destructiveOperations = destructiveOperations;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AddIndexBlockResponse read(StreamInput in) throws IOException {
        return new AddIndexBlockResponse(in);
    }

    @Override
    protected void doExecute(Task task, AddIndexBlockRequest request, ActionListener<AddIndexBlockResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(AddIndexBlockRequest request, ClusterState state) {
        if (request.getBlock().getBlock().levels().contains((Object)ClusterBlockLevel.METADATA_WRITE) && state.blocks().global(ClusterBlockLevel.METADATA_WRITE).isEmpty()) {
            return null;
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(AddIndexBlockRequest request, ClusterState state, ActionListener<AddIndexBlockResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void masterOperation(Task task, AddIndexBlockRequest request, ClusterState state, ActionListener<AddIndexBlockResponse> listener) throws Exception {
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse(new AddIndexBlockResponse(true, false, Collections.emptyList()));
            return;
        }
        AddIndexBlockClusterStateUpdateRequest addBlockRequest = (AddIndexBlockClusterStateUpdateRequest)((AddIndexBlockClusterStateUpdateRequest)((AddIndexBlockClusterStateUpdateRequest)new AddIndexBlockClusterStateUpdateRequest(request.getBlock(), task.getId()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(concreteIndices);
        this.indexStateService.addIndexBlock(addBlockRequest, ActionListener.delegateResponse(listener, (delegatedListener, t) -> {
            logger.debug(() -> new ParameterizedMessage("failed to mark indices as readonly [{}]", (Object)concreteIndices), (Throwable)t);
            delegatedListener.onFailure((Exception)t);
        }));
    }
}

