/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.mapping.put;

import com.carrotsearch.hppc.ObjectHashSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.easysearch.EasysearchGenerationException;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.ValidateActions;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.master.AcknowledgedRequest;
import org.easysearch.common.Strings;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.util.CollectionUtils;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentFactory;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.index.Index;

public class PutMappingRequest
extends AcknowledgedRequest<PutMappingRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    private static ObjectHashSet<String> RESERVED_FIELDS = ObjectHashSet.from((Object[])new String[]{"_uid", "_id", "_type", "_source", "_all", "_analyzer", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl", "_field_names"});
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private String type;
    private String source;
    private String origin = "";
    private Index concreteIndex;
    private boolean writeIndexOnly;

    public PutMappingRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.type = in.readOptionalString();
        this.source = in.readString();
        this.concreteIndex = in.readOptionalWriteable(Index::new);
        this.origin = in.readOptionalString();
        this.writeIndexOnly = in.readBoolean();
    }

    public PutMappingRequest() {
    }

    public PutMappingRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.type == null) {
            this.type = "_doc";
        } else if (this.type.isEmpty()) {
            this.type = "_doc";
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("mapping source is missing", validationException);
        } else if (this.source.isEmpty()) {
            validationException = ValidateActions.addValidationError("mapping source is empty", validationException);
        }
        if (this.concreteIndex != null && !CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError("either concrete index or unresolved indices can be set, concrete index: [" + this.concreteIndex + "] and indices: " + Arrays.asList(this.indices), validationException);
        }
        return validationException;
    }

    @Override
    public PutMappingRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public PutMappingRequest setConcreteIndex(Index index) {
        Objects.requireNonNull(index, "index must not be null");
        this.concreteIndex = index;
        return this;
    }

    public Index getConcreteIndex() {
        return this.concreteIndex;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public PutMappingRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public String type() {
        return this.type;
    }

    public PutMappingRequest type(String type) {
        this.type = type;
        return this;
    }

    public String source() {
        return this.source;
    }

    public PutMappingRequest source(Object ... source) {
        return this.source(PutMappingRequest.buildFromSimplifiedDef(this.type, source));
    }

    public String origin() {
        return this.origin;
    }

    public PutMappingRequest origin(String origin) {
        this.origin = Objects.requireNonNull(origin);
        return this;
    }

    public static XContentBuilder buildFromSimplifiedDef(String type, Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("mapping source must be pairs of fieldnames and properties definition.");
        }
        try {
            String[] s2;
            String[] s1;
            String fieldName;
            int i;
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            if (type != null) {
                builder.startObject(type);
            }
            for (i = 0; i < source.length; ++i) {
                if (!RESERVED_FIELDS.contains((Object)(fieldName = source[i++].toString()))) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.startObject("properties");
            for (i = 0; i < source.length; ++i) {
                if (RESERVED_FIELDS.contains((Object)(fieldName = source[i++].toString()))) continue;
                builder.startObject(fieldName);
                for (String s : s1 = Strings.splitStringByCommaToArray(source[i].toString())) {
                    s2 = Strings.split(s, "=");
                    if (s2.length != 2) {
                        throw new IllegalArgumentException("malformed " + s);
                    }
                    builder.field(s2[0], s2[1]);
                }
                builder.endObject();
            }
            builder.endObject();
            if (type != null) {
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to generate simplified mapping definition", e);
        }
    }

    public PutMappingRequest source(XContentBuilder mappingBuilder) {
        return this.source(BytesReference.bytes(mappingBuilder), mappingBuilder.contentType());
    }

    public PutMappingRequest source(Map<String, ?> mappingSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(mappingSource);
            return this.source(BytesReference.bytes(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new EasysearchGenerationException("Failed to generate [" + mappingSource + "]", e);
        }
    }

    public PutMappingRequest source(String mappingSource, XContentType xContentType) {
        return this.source(new BytesArray(mappingSource), xContentType);
    }

    public PutMappingRequest source(BytesReference mappingSource, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        try {
            this.source = XContentHelper.convertToJson(mappingSource, false, false, xContentType);
            return this;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to convert source to json", e);
        }
    }

    public PutMappingRequest writeIndexOnly(boolean writeIndexOnly) {
        this.writeIndexOnly = writeIndexOnly;
        return this;
    }

    public boolean writeIndexOnly() {
        return this.writeIndexOnly;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.type);
        out.writeString(this.source);
        out.writeOptionalWriteable(this.concreteIndex);
        out.writeOptionalString(this.origin);
        out.writeBoolean(this.writeIndexOnly);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            try (StreamInput stream = new BytesArray(this.source).streamInput();){
                builder.rawValue(stream, XContentType.JSON);
            }
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

