/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.easysearch.EasysearchException;
import org.easysearch.Version;
import org.easysearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.easysearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.single.shard.TransportSingleShardAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.routing.ShardsIterator;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.regex.Regex;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.index.IndexService;
import org.easysearch.index.mapper.DocumentMapper;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MappingLookup;
import org.easysearch.index.shard.ShardId;
import org.easysearch.indices.IndicesService;
import org.easysearch.indices.TypeMissingException;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportGetFieldMappingsIndexAction
extends TransportSingleShardAction<GetFieldMappingsIndexRequest, GetFieldMappingsResponse> {
    private static final String ACTION_NAME = "indices:admin/mappings/fields/get[index]";
    protected final ClusterService clusterService;
    private final IndicesService indicesService;
    private static final ToXContent.Params includeDefaultsParams = new ToXContent.Params(){
        static final String INCLUDE_DEFAULTS = "include_defaults";

        @Override
        public String param(String key) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }
    };

    @Inject
    public TransportGetFieldMappingsIndexAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetFieldMappingsIndexRequest::new, "management");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(GetFieldMappingsIndexRequest request) {
        return false;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected GetFieldMappingsResponse shardOperation(GetFieldMappingsIndexRequest request, ShardId shardId) {
        Set<String> typeIntersection;
        assert (shardId != null);
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        Version indexCreatedVersion = indexService.mapperService().getIndexSettings().getIndexVersionCreated();
        Predicate<String> metadataFieldPredicate = f -> this.indicesService.isMetadataField(indexCreatedVersion, (String)f);
        Predicate<String> fieldPredicate = metadataFieldPredicate.or(this.indicesService.getFieldFilter().apply(shardId.getIndexName()));
        DocumentMapper mapper = indexService.mapperService().documentMapper();
        if (request.types().length == 0) {
            typeIntersection = mapper == null ? Collections.emptySet() : Collections.singleton(mapper.type());
        } else {
            Set<String> set = typeIntersection = mapper != null && Regex.simpleMatch(request.types(), mapper.type()) ? Collections.singleton(mapper.type()) : Collections.emptySet();
            if (typeIntersection.isEmpty()) {
                throw new TypeMissingException(shardId.getIndex(), request.types());
            }
        }
        HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>> typeMappings = new HashMap<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>();
        for (String type : typeIntersection) {
            DocumentMapper documentMapper = indexService.mapperService().documentMapper(type);
            Map<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMapping = TransportGetFieldMappingsIndexAction.findFieldMappingsByType(fieldPredicate, documentMapper, request);
            if (fieldMapping.isEmpty()) continue;
            typeMappings.put(type, fieldMapping);
        }
        return new GetFieldMappingsResponse(Collections.singletonMap(shardId.getIndexName(), Collections.unmodifiableMap(typeMappings)));
    }

    @Override
    protected Writeable.Reader<GetFieldMappingsResponse> getResponseReader() {
        return GetFieldMappingsResponse::new;
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_READ, request.concreteIndex());
    }

    private static Map<String, GetFieldMappingsResponse.FieldMappingMetadata> findFieldMappingsByType(Predicate<String> fieldPredicate, DocumentMapper documentMapper, GetFieldMappingsIndexRequest request) {
        HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMappings = new HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata>();
        MappingLookup allFieldMappers = documentMapper.mappers();
        for (String field : request.fields()) {
            if (Regex.isMatchAllPattern(field)) {
                for (Mapper fieldMapper : allFieldMappers) {
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            if (Regex.isSimpleMatchPattern(field)) {
                for (Mapper fieldMapper : allFieldMappers) {
                    if (!Regex.simpleMatch(field, fieldMapper.name())) continue;
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            Mapper fieldMapper = allFieldMappers.getMapper(field);
            if (fieldMapper != null) {
                TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, field, fieldMapper, fieldMappings, request.includeDefaults());
                continue;
            }
            if (!request.probablySingleFieldRequest()) continue;
            fieldMappings.put(field, GetFieldMappingsResponse.FieldMappingMetadata.NULL);
        }
        return Collections.unmodifiableMap(fieldMappings);
    }

    private static void addFieldMapper(Predicate<String> fieldPredicate, String field, Mapper fieldMapper, Map<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMappings, boolean includeDefaults) {
        if (fieldMappings.containsKey(field)) {
            return;
        }
        if (fieldPredicate.test(field)) {
            try {
                BytesReference bytes = XContentHelper.toXContent(fieldMapper, XContentType.JSON, includeDefaults ? includeDefaultsParams : ToXContent.EMPTY_PARAMS, false);
                fieldMappings.put(field, new GetFieldMappingsResponse.FieldMappingMetadata(fieldMapper.name(), bytes));
            }
            catch (IOException e) {
                throw new EasysearchException("failed to serialize XContent of field [" + field + "]", (Throwable)e, new Object[0]);
            }
        }
    }
}

