/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.easysearch.action.admin.indices.diskusage.IndexSpaceUsageStats;
import org.easysearch.action.support.DefaultShardOperationFailedException;
import org.easysearch.action.support.broadcast.BroadcastResponse;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;

public final class AnalyzeIndexSpaceUsageResponse
extends BroadcastResponse {
    private final Map<String, IndexSpaceUsageStats> stats;

    AnalyzeIndexSpaceUsageResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Map<String, IndexSpaceUsageStats> stats) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.stats = stats;
    }

    AnalyzeIndexSpaceUsageResponse(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readMap(StreamInput::readString, IndexSpaceUsageStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.stats, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    Map<String, IndexSpaceUsageStats> getStats() {
        return this.stats;
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List entries = this.stats.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            builder.startObject((String)entry.getKey());
            ((IndexSpaceUsageStats)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
    }
}

