/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.dangling.delete;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.EasysearchException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.admin.indices.dangling.DanglingIndexInfo;
import org.easysearch.action.admin.indices.dangling.delete.DeleteDanglingIndexRequest;
import org.easysearch.action.admin.indices.dangling.list.ListDanglingIndicesAction;
import org.easysearch.action.admin.indices.dangling.list.ListDanglingIndicesRequest;
import org.easysearch.action.admin.indices.dangling.list.ListDanglingIndicesResponse;
import org.easysearch.action.admin.indices.dangling.list.NodeListDanglingIndicesResponse;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.action.support.master.TransportMasterNodeAction;
import org.easysearch.client.node.NodeClient;
import org.easysearch.cluster.AckedClusterStateUpdateTask;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.ack.AckedRequest;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.metadata.IndexGraveyard;
import org.easysearch.cluster.metadata.IndexMetadata;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.metadata.Metadata;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.settings.Settings;
import org.easysearch.index.Index;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportDeleteDanglingIndexAction
extends TransportMasterNodeAction<DeleteDanglingIndexRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteDanglingIndexAction.class);
    private final Settings settings;
    private final NodeClient nodeClient;

    @Inject
    public TransportDeleteDanglingIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Settings settings, NodeClient nodeClient) {
        super("cluster:admin/indices/dangling/delete", transportService, clusterService, threadPool, actionFilters, DeleteDanglingIndexRequest::new, indexNameExpressionResolver);
        this.settings = settings;
        this.nodeClient = nodeClient;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(final DeleteDanglingIndexRequest deleteRequest, ClusterState state, final ActionListener<AcknowledgedResponse> deleteListener) throws Exception {
        this.findDanglingIndex(deleteRequest.getIndexUUID(), new ActionListener<Index>(){

            @Override
            public void onResponse(final Index indexToDelete) {
                if (!deleteRequest.isAcceptDataLoss()) {
                    deleteListener.onFailure(new IllegalArgumentException("accept_data_loss must be set to true"));
                    return;
                }
                final String indexName = indexToDelete.getName();
                final String indexUUID = indexToDelete.getUUID();
                ActionListener<AcknowledgedResponse> clusterStateUpdatedListener = new ActionListener<AcknowledgedResponse>(){

                    @Override
                    public void onResponse(AcknowledgedResponse response) {
                        deleteListener.onResponse(response);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug("Failed to delete dangling index [" + indexName + "] [" + indexUUID + "]", (Throwable)e);
                        deleteListener.onFailure(e);
                    }
                };
                String taskSource = "delete-dangling-index [" + indexName + "] [" + indexUUID + "]";
                TransportDeleteDanglingIndexAction.this.clusterService.submitStateUpdateTask(taskSource, new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)deleteRequest, (ActionListener)clusterStateUpdatedListener){

                    @Override
                    protected AcknowledgedResponse newResponse(boolean acknowledged) {
                        return new AcknowledgedResponse(acknowledged);
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        return TransportDeleteDanglingIndexAction.this.deleteDanglingIndex(currentState, indexToDelete);
                    }
                });
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug("Failed to find dangling index [" + deleteRequest.getIndexUUID() + "]", (Throwable)e);
                deleteListener.onFailure(e);
            }
        });
    }

    private ClusterState deleteDanglingIndex(ClusterState currentState, Index indexToDelete) {
        Metadata metaData = currentState.getMetadata();
        for (ObjectObjectCursor<String, IndexMetadata> objectObjectCursor : metaData.indices()) {
            if (!indexToDelete.getUUID().equals(((IndexMetadata)objectObjectCursor.value).getIndexUUID())) continue;
            throw new IllegalArgumentException("Refusing to delete dangling index " + indexToDelete + " as an index with UUID [" + indexToDelete.getUUID() + "] already exists in the cluster state");
        }
        if (metaData.indexGraveyard().containsIndex(indexToDelete)) {
            return currentState;
        }
        Metadata.Builder metaDataBuilder = Metadata.builder(metaData);
        IndexGraveyard indexGraveyard = IndexGraveyard.builder(metaDataBuilder.indexGraveyard()).addTombstone(indexToDelete).build(this.settings);
        metaDataBuilder.indexGraveyard(indexGraveyard);
        return ClusterState.builder(currentState).metadata(metaDataBuilder.build()).build();
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteDanglingIndexRequest request, ClusterState state) {
        return null;
    }

    private void findDanglingIndex(final String indexUUID, final ActionListener<Index> listener) {
        this.nodeClient.execute(ListDanglingIndicesAction.INSTANCE, new ListDanglingIndicesRequest(indexUUID), new ActionListener<ListDanglingIndicesResponse>(){

            @Override
            public void onResponse(ListDanglingIndicesResponse response) {
                if (response.hasFailures()) {
                    String nodeIds = response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(","));
                    EasysearchException e = new EasysearchException("Failed to query nodes [" + nodeIds + "]", new Object[0]);
                    for (FailedNodeException failure : response.failures()) {
                        logger.error("Failed to query node [" + failure.nodeId() + "]", (Throwable)failure);
                        e.addSuppressed(failure);
                    }
                    listener.onFailure(e);
                    return;
                }
                List nodes = response.getNodes();
                for (NodeListDanglingIndicesResponse nodeResponse : nodes) {
                    for (DanglingIndexInfo each : nodeResponse.getDanglingIndices()) {
                        if (!each.getIndexUUID().equals(indexUUID)) continue;
                        listener.onResponse(new Index(each.getIndexName(), each.getIndexUUID()));
                        return;
                    }
                }
                listener.onFailure(new IllegalArgumentException("No dangling index found for UUID [" + indexUUID + "]"));
            }

            @Override
            public void onFailure(Exception exp) {
                listener.onFailure(exp);
            }
        });
    }
}

