/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.create;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.easysearch.EasysearchGenerationException;
import org.easysearch.EasysearchParseException;
import org.easysearch.action.ActionRequestValidationException;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.ValidateActions;
import org.easysearch.action.admin.indices.alias.Alias;
import org.easysearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.easysearch.action.support.ActiveShardCount;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.action.support.master.AcknowledgedRequest;
import org.easysearch.common.ParseField;
import org.easysearch.common.Strings;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.collect.MapBuilder;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.xcontent.DeprecationHandler;
import org.easysearch.common.xcontent.LoggingDeprecationHandler;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentFactory;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends AcknowledgedRequest<CreateIndexRequest>
implements IndicesRequest,
ToXContentObject {
    public static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    public static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    private String cause = "";
    private String index;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final Set<Alias> aliases = new HashSet<Alias>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.cause = in.readString();
        this.index = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String type = in.readString();
            String source = in.readString();
            this.mappings.put(type, source);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    public CreateIndexRequest() {
    }

    public CreateIndexRequest(String index) {
        this(index, Settings.Builder.EMPTY_SETTINGS);
    }

    public CreateIndexRequest(String index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public String index() {
        return this.index;
    }

    public CreateIndexRequest index(String index) {
        this.index = index;
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        this.settings(Strings.toString(builder), builder.contentType());
        return this;
    }

    public CreateIndexRequest settings(Map<String, ?> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public CreateIndexRequest mapping(String type, String source, XContentType xContentType) {
        return this.mapping(type, new BytesArray(source), xContentType);
    }

    private CreateIndexRequest mapping(String type, BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        Map<String, Object> mappingAsMap = XContentHelper.convertToMap(source, false, xContentType).v2();
        return this.mapping(type, mappingAsMap);
    }

    public CreateIndexRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public CreateIndexRequest mapping(String type, XContentBuilder source) {
        return this.mapping(type, BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest mapping(String type, Map<String, ?> source) {
        if (this.mappings.containsKey(type)) {
            throw new IllegalStateException("mappings for type \"" + type + "\" were already defined");
        }
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            this.mappings.put(type, Strings.toString(builder));
            return this;
        }
        catch (IOException e) {
            throw new EasysearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest mapping(String type, Object ... source) {
        this.mapping(type, PutMappingRequest.buildFromSimplifiedDef(type, source));
        return this;
    }

    public CreateIndexRequest mapping(XContentBuilder source) {
        return this.mapping(BytesReference.bytes(source), source.contentType());
    }

    private CreateIndexRequest mapping(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        Map<String, Object> mappingAsMap = XContentHelper.convertToMap(source, false, xContentType).v2();
        return this.mapping("_doc", mappingAsMap);
    }

    public CreateIndexRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new EasysearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public CreateIndexRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    public CreateIndexRequest aliases(BytesReference source) {
        CreateIndexRequest createIndexRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                createIndexRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new EasysearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return createIndexRequest;
    }

    public CreateIndexRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public CreateIndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public CreateIndexRequest source(XContentBuilder source) {
        return this.source(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public CreateIndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public CreateIndexRequest source(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        this.source(XContentHelper.convertToMap(source, false, xContentType).v2(), LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public CreateIndexRequest source(Map<String, ?> source, DeprecationHandler deprecationHandler) {
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            String name = entry.getKey();
            if (SETTINGS.match(name, deprecationHandler)) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new EasysearchParseException("key [settings] must be an object", new Object[0]);
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (MAPPINGS.match(name, deprecationHandler)) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            if (ALIASES.match(name, deprecationHandler)) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new EasysearchParseException("unknown key [{}] for create index", name);
        }
        return this;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.index);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        this.waitForActiveShards.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SETTINGS.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(MAPPINGS.getPreferredName());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            StreamInput stream = new BytesArray(entry.getValue()).streamInput();
            try {
                builder.rawField(entry.getKey(), stream, XContentType.JSON);
            }
            finally {
                if (stream == null) continue;
                ((InputStream)stream).close();
            }
        }
        builder.endObject();
        builder.startObject(ALIASES.getPreferredName());
        for (Alias alias : this.aliases) {
            alias.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }
}

