/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.indices.alias.exists;

import java.io.IOException;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.easysearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.master.TransportMasterNodeReadAction;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.block.ClusterBlockException;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.metadata.IndexNameExpressionResolver;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportService;

public class TransportAliasesExistAction
extends TransportMasterNodeReadAction<GetAliasesRequest, AliasesExistResponse> {
    @Inject
    public TransportAliasesExistAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/aliases/exists", transportService, clusterService, threadPool, actionFilters, GetAliasesRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AliasesExistResponse read(StreamInput in) throws IOException {
        return new AliasesExistResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(GetAliasesRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(GetAliasesRequest request, ClusterState state, ActionListener<AliasesExistResponse> listener) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
        boolean result = state.metadata().hasAliases(request.aliases(), concreteIndices);
        listener.onResponse(new AliasesExistResponse(result));
    }
}

