/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.List;
import org.easysearch.EasysearchException;
import org.easysearch.action.FailedNodeException;
import org.easysearch.action.support.nodes.BaseNodeResponse;
import org.easysearch.action.support.nodes.BaseNodesResponse;
import org.easysearch.cluster.ClusterName;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentFactory;

public class NodesReloadSecureSettingsResponse
extends BaseNodesResponse<NodeResponse>
implements ToXContentFragment {
    public NodesReloadSecureSettingsResponse(StreamInput in) throws IOException {
        super(in);
    }

    public NodesReloadSecureSettingsResponse(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(NodeResponse::new);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (NodeResponse node : this.getNodes()) {
            builder.startObject(node.getNode().getId());
            builder.field("name", node.getNode().getName());
            Exception e = node.reloadException();
            if (e != null) {
                builder.startObject("reload_exception");
                EasysearchException.generateThrowableXContent(builder, params, e);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString(builder);
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private Exception reloadException = null;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            if (in.readBoolean()) {
                this.reloadException = in.readException();
            }
        }

        public NodeResponse(DiscoveryNode node, Exception reloadException) {
            super(node);
            this.reloadException = reloadException;
        }

        public Exception reloadException() {
            return this.reloadException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.reloadException != null) {
                out.writeBoolean(true);
                out.writeException(this.reloadException);
            } else {
                out.writeBoolean(false);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)o;
            return this.reloadException != null ? this.reloadException.equals(that.reloadException) : that.reloadException == null;
        }

        public int hashCode() {
            return this.reloadException != null ? this.reloadException.hashCode() : 0;
        }
    }
}

