/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.Arrays;
import org.easysearch.action.support.nodes.BaseNodesRequest;
import org.easysearch.common.CharArrays;
import org.easysearch.common.Nullable;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.settings.SecureString;

public class NodesReloadSecureSettingsRequest
extends BaseNodesRequest<NodesReloadSecureSettingsRequest> {
    @Nullable
    private SecureString secureSettingsPassword;

    public NodesReloadSecureSettingsRequest() {
        super((String[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodesReloadSecureSettingsRequest(StreamInput in) throws IOException {
        super(in);
        BytesReference bytesRef = in.readOptionalBytesReference();
        if (bytesRef != null) {
            byte[] bytes = BytesReference.toBytes(bytesRef);
            try {
                this.secureSettingsPassword = new SecureString(CharArrays.utf8BytesToChars(bytes));
            }
            finally {
                Arrays.fill(bytes, (byte)0);
            }
        } else {
            this.secureSettingsPassword = null;
        }
    }

    public NodesReloadSecureSettingsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    @Nullable
    public SecureString getSecureSettingsPassword() {
        return this.secureSettingsPassword;
    }

    public void setSecureStorePassword(SecureString secureStorePassword) {
        this.secureSettingsPassword = secureStorePassword;
    }

    public void closePassword() {
        if (this.secureSettingsPassword != null) {
            this.secureSettingsPassword.close();
        }
    }

    boolean hasPassword() {
        return this.secureSettingsPassword != null && this.secureSettingsPassword.length() > 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.secureSettingsPassword == null) {
            out.writeOptionalBytesReference(null);
        } else {
            byte[] passwordBytes = CharArrays.toUtf8Bytes(this.secureSettingsPassword.getChars());
            try {
                out.writeOptionalBytesReference(new BytesArray(passwordBytes));
            }
            finally {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
    }
}

