/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.easysearch.action.support.nodes.BaseNodesRequest;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class NodesInfoRequest
extends BaseNodesRequest<NodesInfoRequest> {
    private Set<String> requestedMetrics = Metric.allMetrics();

    public NodesInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.requestedMetrics.clear();
        this.requestedMetrics.addAll(Arrays.asList(in.readStringArray()));
    }

    public NodesInfoRequest(String ... nodesIds) {
        super(nodesIds);
        this.all();
    }

    public NodesInfoRequest clear() {
        this.requestedMetrics.clear();
        return this;
    }

    public NodesInfoRequest all() {
        this.requestedMetrics.addAll(Metric.allMetrics());
        return this;
    }

    public Set<String> requestedMetrics() {
        return new HashSet<String>(this.requestedMetrics);
    }

    public NodesInfoRequest addMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.add(metric);
        return this;
    }

    public NodesInfoRequest addMetrics(String ... metrics) {
        TreeSet<String> metricsSet = new TreeSet<String>(Arrays.asList(metrics));
        if (!Metric.allMetrics().containsAll(metricsSet)) {
            metricsSet.removeAll(Metric.allMetrics());
            String plural = metricsSet.size() == 1 ? "" : "s";
            throw new IllegalStateException("Used illegal metric" + plural + ": " + metricsSet);
        }
        this.requestedMetrics.addAll(metricsSet);
        return this;
    }

    public NodesInfoRequest removeMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.remove(metric);
        return this;
    }

    private void optionallyAddMetric(boolean addMetric, String metricName) {
        if (addMetric) {
            this.requestedMetrics.add(metricName);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.requestedMetrics.toArray(new String[0]));
    }

    public static enum Metric {
        SETTINGS("settings"),
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        TRANSPORT("transport"),
        HTTP("http"),
        PLUGINS("plugins"),
        INGEST("ingest"),
        AGGREGATIONS("aggregations"),
        INDICES("indices");

        private String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }

        boolean containedIn(Set<String> metricNames) {
            return metricNames.contains(this.metricName());
        }

        public static Set<String> allMetrics() {
            return Arrays.stream(Metric.values()).map(Metric::metricName).collect(Collectors.toSet());
        }
    }
}

