/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action;

import java.util.Objects;
import org.easysearch.action.ActionFuture;
import org.easysearch.action.ActionListener;
import org.easysearch.action.ActionRequest;
import org.easysearch.action.ActionResponse;
import org.easysearch.action.ActionType;
import org.easysearch.client.EasysearchClient;
import org.easysearch.common.unit.TimeValue;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse> {
    protected final ActionType<Response> action;
    protected final Request request;
    protected final EasysearchClient client;

    protected ActionRequestBuilder(EasysearchClient client, ActionType<Response> action, Request request) {
        Objects.requireNonNull(action, "action must not be null");
        this.action = action;
        this.request = request;
        this.client = client;
    }

    public Request request() {
        return this.request;
    }

    public ActionFuture<Response> execute() {
        return this.client.execute(this.action, this.request);
    }

    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.request, listener);
    }
}

