/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.user.resolver;

import com.github.zuihou.base.R;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.user.annotation.LoginUser;
import com.github.zuihou.user.feign.UserQuery;
import com.github.zuihou.user.feign.UserResolverService;
import com.github.zuihou.user.model.SysUser;
import com.github.zuihou.utils.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ContextArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(ContextArgumentResolver.class);

    public boolean supportsParameter(MethodParameter mp) {
        return mp.hasParameterAnnotation(LoginUser.class) && mp.getParameterType().equals(SysUser.class);
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) {
        Long userId = BaseContextHandler.getUserId();
        String account = BaseContextHandler.getAccount();
        String name = BaseContextHandler.getName();
        SysUser user = SysUser.builder().id(userId).account(account).name(name).build();
        if (userId == null) {
            return user;
        }
        try {
            UserResolverService userResolverService;
            R<SysUser> result;
            boolean isQuery;
            LoginUser loginUser = (LoginUser)methodParameter.getParameterAnnotation(LoginUser.class);
            boolean bl = isQuery = loginUser.isFull() || loginUser.isStation() || loginUser.isOrg() || loginUser.isRoles();
            if (isQuery && (result = (userResolverService = (UserResolverService)SpringUtils.getBean(UserResolverService.class)).getById(userId, UserQuery.builder().full(loginUser.isFull()).org(loginUser.isOrg()).station(loginUser.isStation()).roles(loginUser.isRoles()).build())).getIsSuccess().booleanValue() && result.getData() != null) {
                return result.getData();
            }
        }
        catch (Exception e) {
            log.warn("\u6ce8\u5165\u767b\u5f55\u4eba\u4fe1\u606f\u65f6\uff0c\u53d1\u751f\u5f02\u5e38. --> {}", (Object)user, (Object)e);
        }
        return user;
    }
}

