/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.user.interceptor;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.github.zuihou.context.BaseContextHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ContextHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(ContextHandlerInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            if (!(handler instanceof HandlerMethod)) {
                log.info("not exec!!! url={}", (Object)request.getRequestURL());
                return super.preHandle(request, response, handler);
            }
            if (!BaseContextHandler.getBoot().booleanValue()) {
                BaseContextHandler.setUserId((String)this.getHeader(request, "userid"));
                BaseContextHandler.setAccount((String)this.getHeader(request, "account"));
                BaseContextHandler.setName((String)this.getHeader(request, "name"));
            }
            BaseContextHandler.setGrayVersion((String)this.getHeader(request, "grayversion"));
            BaseContextHandler.setTenant((String)this.getHeader(request, "tenant"));
            String traceId = request.getHeader("x-trace-header");
            MDC.put((String)"trace", (String)(StrUtil.isEmpty((CharSequence)traceId) ? "" : traceId));
            MDC.put((String)"tenant", (String)BaseContextHandler.getTenant());
            MDC.put((String)"userid", (String)String.valueOf(BaseContextHandler.getUserId()));
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790token\u4fe1\u606f\u65f6\uff0c\u53d1\u751f\u5f02\u5e38. url=" + request.getRequestURI(), (Throwable)e);
        }
        return super.preHandle(request, response, handler);
    }

    private String getHeader(HttpServletRequest request, String name) {
        String value = request.getHeader(name);
        if (StringUtils.isEmpty((Object)value)) {
            return "";
        }
        return URLUtil.decode((String)value);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        BaseContextHandler.remove();
        super.afterCompletion(request, response, handler, ex);
    }
}

