/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.parsers;

import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.github.zuihou.context.BaseContextHandler;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MultiTenantInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(MultiTenantInterceptor.class);
    private String schemaName;

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object parameter = args[1];
        String tenantCode = BaseContextHandler.getTenant();
        if (StrUtil.isEmpty((CharSequence)tenantCode)) {
            return invocation.proceed();
        }
        args[0] = this.getNewMappedStatement(parameter, mappedStatement);
        return invocation.proceed();
    }

    private MappedStatement getNewMappedStatement(Object parameter, MappedStatement mappedStatement) {
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        logger.debug("\u539fSQL\uff1a{}", (Object)boundSql.getSql());
        String resultSql = this.processSqlByInterceptor(boundSql.getSql());
        logger.debug("\u7ed3\u679cSQL\uff1a{}", (Object)resultSql);
        BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), resultSql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        MappedStatement.Builder builder = new MappedStatement.Builder(mappedStatement.getConfiguration(), mappedStatement.getId(), parameterObject -> newBoundSql, mappedStatement.getSqlCommandType());
        builder.resource(mappedStatement.getResource());
        builder.fetchSize(mappedStatement.getFetchSize());
        builder.statementType(mappedStatement.getStatementType());
        builder.keyGenerator(mappedStatement.getKeyGenerator());
        if (mappedStatement.getKeyProperties() != null && mappedStatement.getKeyProperties().length > 0) {
            builder.keyProperty(mappedStatement.getKeyProperties()[0]);
        }
        builder.timeout(mappedStatement.getTimeout());
        builder.parameterMap(mappedStatement.getParameterMap());
        builder.resultMaps(mappedStatement.getResultMaps());
        builder.resultSetType(mappedStatement.getResultSetType());
        builder.cache(mappedStatement.getCache());
        builder.flushCacheRequired(mappedStatement.isFlushCacheRequired());
        builder.useCache(mappedStatement.isUseCache());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return builder.build();
    }

    private void setSQLSchema(SQLSelectQuery sqlSelectQuery) {
        if (sqlSelectQuery instanceof SQLUnionQuery) {
            SQLUnionQuery sqlUnionQuery = (SQLUnionQuery)sqlSelectQuery;
            SQLSelectQuery sqlSelectQueryLeft = sqlUnionQuery.getLeft();
            this.setSQLSchema(sqlSelectQueryLeft);
            SQLSelectQuery sqlSelectQueryRight = sqlUnionQuery.getRight();
            this.setSQLSchema(sqlSelectQueryRight);
        }
        if (sqlSelectQuery instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock sqlSelectQueryBlock = (SQLSelectQueryBlock)sqlSelectQuery;
            SQLTableSource sqlTableSource = sqlSelectQueryBlock.getFrom();
            this.setSQLSchema(sqlTableSource);
            SQLExpr whereSqlExpr = sqlSelectQueryBlock.getWhere();
            if (whereSqlExpr instanceof SQLInSubQueryExpr) {
                SQLInSubQueryExpr sqlInSubQueryExpr = (SQLInSubQueryExpr)whereSqlExpr;
                SQLSelectQuery sqlSelectQueryIn = sqlInSubQueryExpr.getSubQuery().getQuery();
                this.setSQLSchema(sqlSelectQueryIn);
            }
            if (whereSqlExpr instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr sqlBinaryOpExpr = (SQLBinaryOpExpr)whereSqlExpr;
                this.setSQLSchema(sqlBinaryOpExpr);
            }
            List sqlSelectItemList = sqlSelectQueryBlock.getSelectList();
            for (SQLSelectItem sqlSelectItem : sqlSelectItemList) {
                SQLExpr sqlExpr = sqlSelectItem.getExpr();
                this.setSQLSchema(sqlExpr);
                if (!(sqlExpr instanceof SQLMethodInvokeExpr) || !(sqlSelectQuery instanceof SQLSelectQueryBlock) || ((SQLSelectQueryBlock)sqlSelectQuery).getFrom() != null) continue;
                logger.info("\u6267\u884c\u5230\u5b58\u50a8\u8fc7\u7a0b or \u51fd\u6570\u8fd9\u91cc\u4e86");
                ((SQLMethodInvokeExpr)sqlExpr).setOwner((SQLExpr)new SQLIdentifierExpr(this.schemaName));
            }
        }
    }

    public String processSqlByInterceptor(String sql) {
        SQLExprTableSource tableSource;
        SQLExpr where;
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement sqlStatement = parser.parseStatement();
        if (sqlStatement instanceof SQLSelectStatement) {
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
            SQLSelectQuery sqlSelectQuery = sqlSelectStatement.getSelect().getQuery();
            this.setSQLSchema(sqlSelectQuery);
        }
        if (sqlStatement instanceof SQLUpdateStatement) {
            SQLUpdateStatement sqlUpdateStatement = (SQLUpdateStatement)sqlStatement;
            SQLTableSource sqlTableSource = sqlUpdateStatement.getTableSource();
            this.setSQLSchema(sqlTableSource);
            where = sqlUpdateStatement.getWhere();
            this.setSQLSchema(where);
        }
        if (sqlStatement instanceof SQLInsertStatement) {
            SQLInsertStatement sqlInsertStatement = (SQLInsertStatement)sqlStatement;
            tableSource = sqlInsertStatement.getTableSource();
            this.setSQLSchema((SQLTableSource)tableSource);
        }
        if (sqlStatement instanceof SQLDeleteStatement) {
            SQLDeleteStatement sqlDeleteStatement = (SQLDeleteStatement)sqlStatement;
            tableSource = sqlDeleteStatement.getTableSource();
            this.setSQLSchema((SQLTableSource)tableSource);
            where = sqlDeleteStatement.getWhere();
            this.setSQLSchema(where);
        }
        if (sqlStatement instanceof SQLCreateStatement) {
            SQLCreateTableStatement sqlCreateStatement = (SQLCreateTableStatement)sqlStatement;
            tableSource = sqlCreateStatement.getTableSource();
            this.setSQLSchema((SQLTableSource)tableSource);
        }
        return sqlStatement.toString();
    }

    private void setSQLSchema(SQLTableSource sqlTableSource) {
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)sqlTableSource;
            SQLTableSource sqlTableSourceLeft = sqlJoinTableSource.getLeft();
            this.setSQLSchema(sqlTableSourceLeft);
            SQLTableSource sqlTableSourceRight = sqlJoinTableSource.getRight();
            this.setSQLSchema(sqlTableSourceRight);
            SQLExpr condition = sqlJoinTableSource.getCondition();
            this.setSQLSchema(condition);
        }
        if (sqlTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource sqlSubqueryTableSource = (SQLSubqueryTableSource)sqlTableSource;
            SQLSelectQuery sqlSelectQuery = sqlSubqueryTableSource.getSelect().getQuery();
            this.setSQLSchema(sqlSelectQuery);
        }
        if (sqlTableSource instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource sqlUnionQueryTableSource = (SQLUnionQueryTableSource)sqlTableSource;
            SQLSelectQuery sqlSelectQueryLeft = sqlUnionQueryTableSource.getUnion().getLeft();
            this.setSQLSchema(sqlSelectQueryLeft);
            SQLSelectQuery sqlSelectQueryRight = sqlUnionQueryTableSource.getUnion().getRight();
            this.setSQLSchema(sqlSelectQueryRight);
        }
        if (sqlTableSource instanceof SQLExprTableSource) {
            MySqlInsertStatement mySqlInsertStatement;
            SQLSelect sqlSelect;
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlTableSource;
            SQLObject sqlObject = sqlExprTableSource.getParent();
            if (sqlObject instanceof MySqlDeleteStatement) {
                MySqlDeleteStatement mySqlDeleteStatement = (MySqlDeleteStatement)sqlObject;
                SQLExpr sqlExpr = mySqlDeleteStatement.getWhere();
                this.setSQLSchema(sqlExpr);
            }
            if (sqlObject instanceof MySqlInsertStatement && (sqlSelect = (mySqlInsertStatement = (MySqlInsertStatement)sqlObject).getQuery()) != null) {
                SQLSelectQuery sqlSelectQuery = sqlSelect.getQuery();
                this.setSQLSchema(sqlSelectQuery);
            }
            sqlExprTableSource.setSchema(this.schemaName);
        }
    }

    private void setSQLSchema(SQLBinaryOpExpr sqlBinaryOpExpr) {
        SQLExpr sqlExprLeft = sqlBinaryOpExpr.getLeft();
        this.setSQLSchema(sqlExprLeft);
        SQLExpr sqlExprRight = sqlBinaryOpExpr.getRight();
        this.setSQLSchema(sqlExprRight);
    }

    private void setSQLSchema(SQLExpr sqlExpr) {
        SQLSelectQuery sqlSelectQuery;
        if (sqlExpr instanceof SQLInSubQueryExpr) {
            SQLInSubQueryExpr sqlInSubQueryExpr = (SQLInSubQueryExpr)sqlExpr;
            sqlSelectQuery = sqlInSubQueryExpr.getSubQuery().getQuery();
            this.setSQLSchema(sqlSelectQuery);
        }
        if (sqlExpr instanceof SQLExistsExpr) {
            SQLExistsExpr sqlExistsExpr = (SQLExistsExpr)sqlExpr;
            sqlSelectQuery = sqlExistsExpr.getSubQuery().getQuery();
            this.setSQLSchema(sqlSelectQuery);
        }
        if (sqlExpr instanceof SQLCaseExpr) {
            SQLCaseExpr sqlCaseExpr = (SQLCaseExpr)sqlExpr;
            List sqlCaseExprItemList = sqlCaseExpr.getItems();
            for (SQLCaseExpr.Item item : sqlCaseExprItemList) {
                SQLExpr sqlExprItem = item.getValueExpr();
                this.setSQLSchema(sqlExprItem);
            }
        }
        if (sqlExpr instanceof SQLQueryExpr) {
            SQLQueryExpr sqlQueryExpr = (SQLQueryExpr)sqlExpr;
            sqlSelectQuery = sqlQueryExpr.getSubQuery().getQuery();
            this.setSQLSchema(sqlSelectQuery);
        }
        if (sqlExpr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr sqlBinaryOpExpr = (SQLBinaryOpExpr)sqlExpr;
            this.setSQLSchema(sqlBinaryOpExpr);
        }
        if (sqlExpr instanceof SQLAggregateExpr) {
            SQLAggregateExpr sqlAggregateExpr = (SQLAggregateExpr)sqlExpr;
            List arguments = sqlAggregateExpr.getArguments();
            for (SQLExpr argument : arguments) {
                this.setSQLSchema(argument);
            }
        }
    }
}

