/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.parsers;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.database.parsers.ITableNameHandler;
import com.github.zuihou.database.parsers.MultiTenantInterceptor;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;

public class DynamicTableNameParser
implements ISqlParser {
    private String database = "zuihou_base";
    private ITableNameHandler defaultTableNameHandler = (metaObject, sql, tableName) -> {
        String tenantCode = BaseContextHandler.getTenant();
        if (StrUtil.isEmpty((CharSequence)tenantCode)) {
            return tableName;
        }
        return this.database + "." + tableName;
    };
    private Map<String, ITableNameHandler> tableNameHandlerMap;

    public DynamicTableNameParser(String database) {
        this.database = database;
    }

    public SqlInfo parser(MetaObject metaObject, String sql) {
        if (this.allowProcess(metaObject)) {
            String tenantCode = BaseContextHandler.getTenant();
            if (StrUtil.isEmpty((CharSequence)tenantCode)) {
                return null;
            }
            MultiTenantInterceptor multiTenantInterceptor = new MultiTenantInterceptor();
            String schemaName = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{this.database, tenantCode});
            multiTenantInterceptor.setSchemaName(schemaName);
            String parsedSql = multiTenantInterceptor.processSqlByInterceptor(sql);
            return SqlInfo.newInstance().setSql(parsedSql);
        }
        return null;
    }

    private boolean allowProcess(MetaObject metaObject) {
        return true;
    }

    public String getDatabase() {
        return this.database;
    }

    public ITableNameHandler getDefaultTableNameHandler() {
        return this.defaultTableNameHandler;
    }

    public Map<String, ITableNameHandler> getTableNameHandlerMap() {
        return this.tableNameHandlerMap;
    }

    public DynamicTableNameParser setDatabase(String database) {
        this.database = database;
        return this;
    }

    public DynamicTableNameParser setDefaultTableNameHandler(ITableNameHandler defaultTableNameHandler) {
        this.defaultTableNameHandler = defaultTableNameHandler;
        return this;
    }

    public DynamicTableNameParser setTableNameHandlerMap(Map<String, ITableNameHandler> tableNameHandlerMap) {
        this.tableNameHandlerMap = tableNameHandlerMap;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicTableNameParser)) {
            return false;
        }
        DynamicTableNameParser other = (DynamicTableNameParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        ITableNameHandler this$defaultTableNameHandler = this.getDefaultTableNameHandler();
        ITableNameHandler other$defaultTableNameHandler = other.getDefaultTableNameHandler();
        if (this$defaultTableNameHandler == null ? other$defaultTableNameHandler != null : !this$defaultTableNameHandler.equals(other$defaultTableNameHandler)) {
            return false;
        }
        Map<String, ITableNameHandler> this$tableNameHandlerMap = this.getTableNameHandlerMap();
        Map<String, ITableNameHandler> other$tableNameHandlerMap = other.getTableNameHandlerMap();
        return !(this$tableNameHandlerMap == null ? other$tableNameHandlerMap != null : !((Object)this$tableNameHandlerMap).equals(other$tableNameHandlerMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicTableNameParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        ITableNameHandler $defaultTableNameHandler = this.getDefaultTableNameHandler();
        result = result * 59 + ($defaultTableNameHandler == null ? 43 : $defaultTableNameHandler.hashCode());
        Map<String, ITableNameHandler> $tableNameHandlerMap = this.getTableNameHandlerMap();
        result = result * 59 + ($tableNameHandlerMap == null ? 43 : ((Object)$tableNameHandlerMap).hashCode());
        return result;
    }

    public String toString() {
        return "DynamicTableNameParser(database=" + this.getDatabase() + ", defaultTableNameHandler=" + this.getDefaultTableNameHandler() + ", tableNameHandlerMap=" + this.getTableNameHandlerMap() + ")";
    }

    public DynamicTableNameParser() {
    }
}

