/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.mybatis.auth;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import com.github.zuihou.context.BaseContextHandler;
import com.github.zuihou.database.mybatis.auth.DataScope;
import com.github.zuihou.database.mybatis.auth.DataScopeType;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataScopeInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);
    private final Function<Long, Map<String, Object>> function;

    public Object intercept(Invocation invocation) {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        this.sqlParser(metaObject);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        String originalSql = boundSql.getSql();
        Object parameterObject = boundSql.getParameterObject();
        DataScope dataScope = this.findDataScopeObject(parameterObject);
        if (dataScope == null) {
            return invocation.proceed();
        }
        String scopeName = dataScope.getScopeName();
        String selfScopeName = dataScope.getSelfScopeName();
        Long userId = dataScope.getUserId() == null ? BaseContextHandler.getUserId() : dataScope.getUserId();
        List orgIds = dataScope.getOrgIds();
        DataScopeType dsType = DataScopeType.SELF;
        if (CollectionUtil.isEmpty(orgIds)) {
            Map<String, Object> result = this.function.apply(userId);
            if (result == null) {
                return invocation.proceed();
            }
            Integer type = (Integer)result.get("dsType");
            dsType = DataScopeType.get(type);
            orgIds = (List)result.get("orgIds");
        }
        if (DataScopeType.ALL.eq(dsType)) {
            return invocation.proceed();
        }
        if (DataScopeType.SELF.eq(dsType)) {
            originalSql = "select * from (" + originalSql + ") temp_data_scope where temp_data_scope." + selfScopeName + " = " + userId;
        } else if (StrUtil.isNotBlank((CharSequence)scopeName) && CollectionUtil.isNotEmpty(orgIds)) {
            String join = CollectionUtil.join(orgIds, (CharSequence)",");
            originalSql = "select * from (" + originalSql + ") temp_data_scope where temp_data_scope." + scopeName + " in (" + join + ")";
        }
        metaObject.setValue("delegate.boundSql.sql", (Object)originalSql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private DataScope findDataScopeObject(Object parameterObj) {
        if (parameterObj instanceof DataScope) {
            return (DataScope)parameterObj;
        }
        if (parameterObj instanceof Map) {
            for (Object val : ((Map)parameterObj).values()) {
                if (!(val instanceof DataScope)) continue;
                return (DataScope)val;
            }
        }
        return null;
    }

    public DataScopeInterceptor(Function<Long, Map<String, Object>> function) {
        this.function = function;
    }
}

