/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.database.datasource;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.github.zuihou.base.entity.Entity;
import com.github.zuihou.base.entity.SuperEntity;
import com.github.zuihou.context.BaseContextHandler;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(MyMetaObjectHandler.class);
    private static final String ID_TYPE = "java.lang.String";
    private long workerId;
    private long dataCenterId;

    public MyMetaObjectHandler(long workerId, long dataCenterId) {
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public void insertFill(MetaObject metaObject) {
        TableInfo tableInfo;
        boolean flag = true;
        if (metaObject.getOriginalObject() instanceof SuperEntity) {
            SuperEntity entity;
            Object oldId = ((SuperEntity)metaObject.getOriginalObject()).getId();
            if (oldId != null) {
                flag = false;
            }
            if ((entity = (SuperEntity)metaObject.getOriginalObject()).getCreateTime() == null) {
                this.setFieldValByName("createTime", LocalDateTime.now(), metaObject);
            }
            if (entity.getCreateUser() == null || entity.getCreateUser().equals(0)) {
                Object userIdVal = ID_TYPE.equals(metaObject.getGetterType("createUser").getName()) ? String.valueOf(BaseContextHandler.getUserId()) : BaseContextHandler.getUserId();
                this.setFieldValByName("createUser", userIdVal, metaObject);
            }
        }
        if (metaObject.getOriginalObject() instanceof Entity) {
            Entity entity = (Entity)metaObject.getOriginalObject();
            this.update(metaObject, entity);
        }
        if (!flag) {
            return;
        }
        Snowflake snowflake = IdUtil.getSnowflake((long)this.workerId, (long)this.dataCenterId);
        Long id = snowflake.nextId();
        if (metaObject.hasGetter("id")) {
            Object idVal = ID_TYPE.equals(metaObject.getGetterType("id").getName()) ? String.valueOf(id) : id;
            this.setFieldValByName("id", idVal, metaObject);
            return;
        }
        TableInfo tableInfo2 = tableInfo = metaObject.hasGetter("MP_OPTLOCK_ET_ORIGINAL") ? TableInfoHelper.getTableInfo(metaObject.getValue("MP_OPTLOCK_ET_ORIGINAL").getClass()) : TableInfoHelper.getTableInfo(metaObject.getOriginalObject().getClass());
        if (tableInfo == null) {
            return;
        }
        Class keyType = tableInfo.getKeyType();
        if (keyType == null) {
            return;
        }
        String keyProperty = tableInfo.getKeyProperty();
        Field idField = ReflectUtil.getField(metaObject.getOriginalObject().getClass(), (String)keyProperty);
        Object fieldValue = ReflectUtil.getFieldValue((Object)metaObject.getOriginalObject(), (Field)idField);
        if (ObjectUtil.isNotEmpty((Object)fieldValue)) {
            return;
        }
        Object idVal = keyType.getName().equalsIgnoreCase(ID_TYPE) ? String.valueOf(id) : id;
        this.setFieldValByName(keyProperty, idVal, metaObject);
    }

    private void update(MetaObject metaObject, Entity entity, String et) {
        if (entity.getUpdateUser() == null || entity.getUpdateUser().equals(0)) {
            Object userIdVal = ID_TYPE.equals(metaObject.getGetterType(et + "updateUser").getName()) ? String.valueOf(BaseContextHandler.getUserId()) : BaseContextHandler.getUserId();
            this.setFieldValByName("updateUser", BaseContextHandler.getUserId(), metaObject);
        }
        if (entity.getUpdateTime() == null) {
            this.setFieldValByName("updateTime", LocalDateTime.now(), metaObject);
        }
    }

    private void update(MetaObject metaObject, Entity entity) {
        this.update(metaObject, entity, "");
    }

    public void updateFill(MetaObject metaObject) {
        log.debug("start update fill ....");
        if (metaObject.getOriginalObject() instanceof Entity) {
            Entity entity = (Entity)metaObject.getOriginalObject();
            this.update(metaObject, entity);
        } else {
            Object et = metaObject.getValue("et");
            if (et != null && et instanceof Entity) {
                Entity entity = (Entity)et;
                this.update(metaObject, entity, "et.");
            }
        }
    }
}

