/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptableMutablePropertySourcesInterceptor;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptablePropertySourceMethodInterceptor;
import com.ulisesbocchio.jasyptspringboot.configuration.EnvCopy;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableEnumerablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableMapPropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableMutablePropertySourcesWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableSystemEnvironmentPropertySourceWrapper;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;

public class EncryptablePropertySourceConverter {
    private static final Logger log = LoggerFactory.getLogger(EncryptablePropertySourceConverter.class);
    private static final List<String> DEFAULT_SKIP_PROPERTY_SOURCE_CLASSES = Arrays.asList("org.springframework.core.env.PropertySource$StubPropertySource", "org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource");
    private final InterceptionMode interceptionMode;
    private final List<Class<PropertySource<?>>> skipPropertySourceClasses;
    private final EncryptablePropertyResolver propertyResolver;
    private final EncryptablePropertyFilter propertyFilter;

    public EncryptablePropertySourceConverter(InterceptionMode interceptionMode, List<Class<PropertySource<?>>> skipPropertySourceClasses, EncryptablePropertyResolver propertyResolver, EncryptablePropertyFilter propertyFilter) {
        this.interceptionMode = interceptionMode;
        this.skipPropertySourceClasses = Stream.concat(skipPropertySourceClasses.stream(), EncryptablePropertySourceConverter.defaultSkipPropertySourceClasses().stream()).collect(Collectors.toList());
        this.propertyResolver = propertyResolver;
        this.propertyFilter = propertyFilter;
    }

    static List<Class<PropertySource<?>>> defaultSkipPropertySourceClasses() {
        return DEFAULT_SKIP_PROPERTY_SOURCE_CLASSES.stream().map(EncryptablePropertySourceConverter::getPropertiesClass).collect(Collectors.toList());
    }

    public static Class<PropertySource<?>> getPropertiesClass(String className) {
        try {
            Class<PropertySource<?>> clazz = Class.forName(className);
            if (PropertySource.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            throw new IllegalArgumentException(String.format("Invalid jasypt.encryptor.skip-property-sources: Class %s does not implement %s", className, PropertySource.class.getName()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Invalid jasypt.encryptor.skip-property-sources: Class %s not found", className), e);
        }
    }

    public void convertPropertySources(MutablePropertySources propSources) {
        propSources.stream().filter(ps -> !(ps instanceof EncryptablePropertySource)).map(this::makeEncryptable).collect(Collectors.toList()).forEach(ps -> propSources.replace(ps.getName(), ps));
    }

    public <T> PropertySource<T> makeEncryptable(PropertySource<T> propertySource) {
        if (propertySource instanceof EncryptablePropertySource || this.skipPropertySourceClasses.stream().anyMatch(skipClass -> skipClass.equals(propertySource.getClass()))) {
            if (!(propertySource instanceof EncryptablePropertySource)) {
                log.info("Skipping PropertySource {} [{}", (Object)propertySource.getName(), propertySource.getClass());
            }
            return propertySource;
        }
        PropertySource<T> encryptablePropertySource = this.convertPropertySource(propertySource);
        log.info("Converting PropertySource {} [{}] to {}", new Object[]{propertySource.getName(), propertySource.getClass().getName(), AopUtils.isAopProxy(encryptablePropertySource) ? "AOP Proxy" : encryptablePropertySource.getClass().getSimpleName()});
        return encryptablePropertySource;
    }

    public MutablePropertySources proxyMutablePropertySources(MutablePropertySources propertySources, EnvCopy envCopy) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget(MutablePropertySources.class);
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(PropertySources.class);
        proxyFactory.setTarget((Object)propertySources);
        proxyFactory.addAdvice((Advice)new EncryptableMutablePropertySourcesInterceptor(this, envCopy));
        return (MutablePropertySources)proxyFactory.getProxy();
    }

    public MutablePropertySources convertMutablePropertySources(InterceptionMode mode, MutablePropertySources originalPropertySources, EnvCopy envCopy) {
        return InterceptionMode.PROXY == mode ? this.proxyMutablePropertySources(originalPropertySources, envCopy) : new EncryptableMutablePropertySourcesWrapper((PropertySources)originalPropertySources, this, envCopy);
    }

    private <T> PropertySource<T> convertPropertySource(PropertySource<T> propertySource) {
        return this.interceptionMode == InterceptionMode.PROXY ? this.proxyPropertySource(propertySource) : this.instantiatePropertySource(propertySource);
    }

    private <T> PropertySource<T> proxyPropertySource(PropertySource<T> propertySource) {
        if (CommandLinePropertySource.class.isAssignableFrom(propertySource.getClass()) || Modifier.isFinal(propertySource.getClass().getModifiers())) {
            return this.instantiatePropertySource(propertySource);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(propertySource.getClass());
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(EncryptablePropertySource.class);
        proxyFactory.setTarget(propertySource);
        proxyFactory.addAdvice(new EncryptablePropertySourceMethodInterceptor<T>(propertySource, this.propertyResolver, this.propertyFilter));
        return (PropertySource)proxyFactory.getProxy();
    }

    private <T> PropertySource<T> instantiatePropertySource(PropertySource<T> propertySource) {
        Object encryptablePropertySource = EncryptablePropertySourceConverter.needsProxyAnyway(propertySource) ? this.proxyPropertySource(propertySource) : (propertySource instanceof SystemEnvironmentPropertySource ? new EncryptableSystemEnvironmentPropertySourceWrapper((SystemEnvironmentPropertySource)propertySource, this.propertyResolver, this.propertyFilter) : (propertySource instanceof MapPropertySource ? new EncryptableMapPropertySourceWrapper((MapPropertySource)propertySource, this.propertyResolver, this.propertyFilter) : (propertySource instanceof EnumerablePropertySource ? new EncryptableEnumerablePropertySourceWrapper((EnumerablePropertySource)propertySource, this.propertyResolver, this.propertyFilter) : new EncryptablePropertySourceWrapper<T>(propertySource, this.propertyResolver, this.propertyFilter))));
        return encryptablePropertySource;
    }

    private static boolean needsProxyAnyway(PropertySource<?> ps) {
        return EncryptablePropertySourceConverter.needsProxyAnyway(ps.getClass());
    }

    private static boolean needsProxyAnyway(Class<? extends PropertySource<?>> psClass) {
        return EncryptablePropertySourceConverter.needsProxyAnyway(psClass.getName());
    }

    private static boolean needsProxyAnyway(String className) {
        return Stream.of(new Object[0]).anyMatch(className::equals);
    }
}

