/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime.buildin;

import java.io.InputStream;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import jetbrick.collection.iterator.LoopIterator;
import jetbrick.io.IoUtils;
import jetbrick.io.resource.Resource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.io.stream.UnsafeCharArrayWriter;
import jetbrick.template.Errors;
import jetbrick.template.JetTemplateMacro;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.JetWriter;
import jetbrick.util.PathUtils;
import org.slf4j.LoggerFactory;

public final class JetFunctions {
    private static final SecureRandom RANDOM = new SecureRandom();

    public static Date now() {
        return new Date();
    }

    public static int random() {
        return RANDOM.nextInt();
    }

    public static UUID uuid() {
        return UUID.randomUUID();
    }

    public static Iterator<Integer> range(int start, int stop) {
        return new LoopIterator(start, stop);
    }

    public static Iterator<Integer> range(int start, int stop, int step) {
        return new LoopIterator(start, stop, step);
    }

    public static String includeGet(String relativeName) throws ResourceNotFoundException {
        return JetFunctions.includeGet(relativeName, null);
    }

    public static String includeGet(String relativeName, Map<String, Object> parameters) throws ResourceNotFoundException {
        InterpretContext ctx = InterpretContext.current();
        String name = PathUtils.getRelativePath((String)ctx.getTemplate().getName(), (String)relativeName);
        JetWriter originWriter = ctx.getWriter();
        UnsafeCharArrayWriter out = new UnsafeCharArrayWriter(1024);
        JetWriter writer = JetWriter.create((Writer)out, originWriter.getCharset(), false, false);
        ctx.setWriter(writer);
        ctx.doIncludeCall(name, parameters, null);
        ctx.setWriter(originWriter);
        return out.toString();
    }

    public static String fileGet(String relativeName) throws ResourceNotFoundException {
        InterpretContext ctx = InterpretContext.current();
        String encoding = ctx.getEngine().getConfig().getInputEncoding().name();
        return JetFunctions.fileGet(relativeName, encoding);
    }

    public static String fileGet(String relativeName, String encoding) {
        InterpretContext ctx = InterpretContext.current();
        String name = PathUtils.getRelativePath((String)ctx.getTemplate().getName(), (String)relativeName);
        Resource resource = ctx.getEngine().getResource(name);
        return IoUtils.toString((InputStream)resource.openStream(), (String)encoding);
    }

    public static String macroGet(String name, Object ... arguments) {
        InterpretContext ctx = InterpretContext.current();
        Class<?>[] argumentTypes = ParameterUtils.getParameterTypes(arguments);
        JetTemplateMacro macro = ctx.getTemplate().resolveMacro(name, argumentTypes, true);
        if (macro == null) {
            throw new IllegalStateException(Errors.format("cannot resolve macro: %s", name));
        }
        JetWriter originWriter = ctx.getWriter();
        UnsafeCharArrayWriter out = new UnsafeCharArrayWriter(128);
        ctx.setWriter(JetWriter.create((Writer)out, originWriter.getCharset(), false, false));
        ctx.doMacroCall(macro, arguments);
        ctx.setWriter(originWriter);
        return out.toString();
    }

    public static void debug(String format, Object ... args) {
        LoggerFactory.getLogger((String)"jetx.debug").info(format, args);
    }
}

