/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.runtime;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import jetbrick.template.runtime.OriginalStream;
import jetbrick.template.runtime.writer.JetOutputStreamPrinter;
import jetbrick.template.runtime.writer.JetOutputStreamPrinterEx;
import jetbrick.template.runtime.writer.JetWriterPrinter;
import jetbrick.template.runtime.writer.JetWriterPrinterEx;
import jetbrick.template.runtime.writer.TrimLeadingWhitespacesOutputStream;
import jetbrick.template.runtime.writer.TrimLeadingWhitespacesWriter;

public abstract class JetWriter
implements OriginalStream,
Closeable,
Flushable {
    public static JetWriter create(Writer os, Charset charset, boolean trimLeadingWhitespaces, boolean skipErrors) {
        if (skipErrors || os instanceof PrintWriter) {
            if (trimLeadingWhitespaces) {
                os = new TrimLeadingWhitespacesWriter(os);
            }
            return new JetWriterPrinter(os, charset);
        }
        if (trimLeadingWhitespaces) {
            os = new TrimLeadingWhitespacesWriter(os);
        }
        return new JetWriterPrinterEx(os, charset);
    }

    public static JetWriter create(OutputStream os, Charset charset, boolean trimLeadingWhitespaces, boolean skipErrors) {
        if (skipErrors || os instanceof PrintStream) {
            if (trimLeadingWhitespaces) {
                os = new TrimLeadingWhitespacesOutputStream(os);
            }
            return new JetOutputStreamPrinter(os, charset);
        }
        if (trimLeadingWhitespaces) {
            os = new TrimLeadingWhitespacesOutputStream(os);
        }
        return new JetOutputStreamPrinterEx(os, charset);
    }

    public static JetWriter create(JetWriter os, boolean trimLeadingWhitespaces) {
        if (!trimLeadingWhitespaces) {
            return os;
        }
        Object out = os.getOriginStream();
        if (out instanceof OriginalStream) {
            out = ((OriginalStream)out).getOriginStream();
        }
        if (out instanceof OutputStream) {
            return JetWriter.create((OutputStream)out, os.getCharset(), trimLeadingWhitespaces, os.isSkipErrors());
        }
        return JetWriter.create((Writer)out, os.getCharset(), trimLeadingWhitespaces, os.isSkipErrors());
    }

    @Override
    public abstract Object getOriginStream();

    public abstract boolean isStreaming();

    public abstract Charset getCharset();

    public abstract boolean isSkipErrors();

    public abstract void print(int var1) throws IOException;

    public abstract void print(byte[] var1) throws IOException;

    public abstract void print(byte[] var1, int var2, int var3) throws IOException;

    public abstract void print(char[] var1) throws IOException;

    public abstract void print(char[] var1, int var2, int var3) throws IOException;

    public abstract void print(String var1) throws IOException;

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;
}

