/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.Errors;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.parser.ast.ALU;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.property.Getter;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;

public final class AstInvokeField
extends AstExpression {
    private final AstExpression objectExpression;
    private final String name;
    private final boolean nullSafe;
    private Getter last;
    private boolean unsafe;

    public AstInvokeField(AstExpression objectExpression, String name, boolean nullSafe, Position position) {
        super(position);
        this.objectExpression = objectExpression;
        this.name = name;
        this.nullSafe = nullSafe;
        this.last = null;
        this.unsafe = true;
    }

    @Override
    public Object execute(InterpretContext ctx) throws InterpretException {
        Object object = this.objectExpression.execute(ctx);
        if (object == null) {
            if (this.nullSafe || ctx.getTemplate().getOption().isSafecall()) {
                return null;
            }
            throw new InterpretException("object is null").set(this.position);
        }
        if (object == ALU.VOID) {
            throw new InterpretException("object is void").set(this.position);
        }
        return this.doInvokeGetter(ctx, this.last, object);
    }

    private Object doInvokeGetter(InterpretContext ctx, Getter getter, Object object) throws InterpretException {
        boolean useLatest;
        boolean bl = useLatest = getter != null;
        if (getter == null) {
            Class<?> objectClass = this.objectExpression.getResultType(ctx.getValueStack(), object);
            getter = ctx.getGlobalResolver().resolveGetter(objectClass, this.name);
            if (getter == null) {
                String signature = SignatureUtils.getFieldSignature(objectClass, this.name);
                throw new InterpretException("cannot resolve property: %s", signature).set(this.position);
            }
            this.last = getter;
        }
        if (this.unsafe) {
            JetSecurityManager securityManager = ctx.getSecurityManager();
            if (securityManager != null) {
                try {
                    getter.checkAccess(securityManager);
                }
                catch (RuntimeException e) {
                    throw new InterpretException(e).set(this.position);
                }
            }
            this.unsafe = false;
        }
        try {
            return getter.get(object);
        }
        catch (InterpretException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (useLatest && Errors.isReflectIllegalArgumentException(e)) {
                return this.doInvokeGetter(ctx, null, object);
            }
            String signature = object.getClass().getName() + "#" + this.name;
            throw new InterpretException("property get error: %s", signature).cause(e).set(this.position);
        }
    }
}

