/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser.ast;

import jetbrick.template.Errors;
import jetbrick.template.parser.ast.AstDirective;
import jetbrick.template.parser.ast.AstExpressionList;
import jetbrick.template.parser.ast.AstStatementList;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.resolver.ParameterUtils;
import jetbrick.template.resolver.SignatureUtils;
import jetbrick.template.resolver.tag.TagInvoker;
import jetbrick.template.runtime.InterpretContext;
import jetbrick.template.runtime.InterpretException;
import jetbrick.template.runtime.JetTagContext;
import jetbrick.util.ArrayUtils;

public final class AstDirectiveTag
extends AstDirective {
    private final String name;
    private final AstExpressionList argumentList;
    private final JetTagContext tagContext;
    private TagInvoker last;

    public AstDirectiveTag(String name, AstExpressionList argumentList, AstStatementList statements, Position position) {
        super(position);
        this.name = name;
        this.argumentList = argumentList;
        this.tagContext = new JetTagContext(statements);
    }

    @Override
    public void execute(InterpretContext ctx) throws InterpretException {
        Object[] arguments = this.argumentList == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : this.argumentList.execute(ctx);
        this.doInvoke(ctx, this.last, arguments);
    }

    private void doInvoke(InterpretContext ctx, TagInvoker invoker, Object[] arguments) throws InterpretException {
        boolean useLatest;
        boolean bl = useLatest = invoker != null;
        if (invoker == null) {
            Class<?>[] argumentTypes = ParameterUtils.getParameterTypes(arguments);
            invoker = ctx.getGlobalResolver().resolveTag(this.name, argumentTypes);
            if (invoker == null) {
                String signature = SignatureUtils.getFunctionSignature(this.name, argumentTypes);
                throw new InterpretException("cannot resolve tag: %s", signature).set(this.position);
            }
            this.last = invoker;
        }
        try {
            invoker.invoke(this.tagContext, arguments);
        }
        catch (InterpretException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (useLatest && Errors.isReflectIllegalArgumentException(e)) {
                this.doInvoke(ctx, null, arguments);
            }
            throw new InterpretException(e).set(this.position);
        }
    }
}

