/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jetbrick.template.parser.ParserContext;
import jetbrick.template.parser.SyntaxException;
import jetbrick.template.parser.ast.AstConstant;
import jetbrick.template.parser.ast.AstConstantList;
import jetbrick.template.parser.ast.AstConstantMap;
import jetbrick.template.parser.ast.AstConstantMapEntry;
import jetbrick.template.parser.ast.AstDirectiveBreak;
import jetbrick.template.parser.ast.AstDirectiveCall;
import jetbrick.template.parser.ast.AstDirectiveContinue;
import jetbrick.template.parser.ast.AstDirectiveFor;
import jetbrick.template.parser.ast.AstDirectiveIf;
import jetbrick.template.parser.ast.AstDirectiveInclude;
import jetbrick.template.parser.ast.AstDirectiveMacro;
import jetbrick.template.parser.ast.AstDirectiveNoop;
import jetbrick.template.parser.ast.AstDirectiveReturn;
import jetbrick.template.parser.ast.AstDirectiveSet;
import jetbrick.template.parser.ast.AstDirectiveStop;
import jetbrick.template.parser.ast.AstDirectiveTag;
import jetbrick.template.parser.ast.AstExpression;
import jetbrick.template.parser.ast.AstExpressionList;
import jetbrick.template.parser.ast.AstIdentifier;
import jetbrick.template.parser.ast.AstInvokeField;
import jetbrick.template.parser.ast.AstInvokeFieldStatic;
import jetbrick.template.parser.ast.AstInvokeFunction;
import jetbrick.template.parser.ast.AstInvokeIndexGet;
import jetbrick.template.parser.ast.AstInvokeMethod;
import jetbrick.template.parser.ast.AstInvokeMethodStatic;
import jetbrick.template.parser.ast.AstInvokeNewArray;
import jetbrick.template.parser.ast.AstInvokeNewObject;
import jetbrick.template.parser.ast.AstNode;
import jetbrick.template.parser.ast.AstOperatorBinary;
import jetbrick.template.parser.ast.AstOperatorEquals;
import jetbrick.template.parser.ast.AstOperatorInstanceof;
import jetbrick.template.parser.ast.AstOperatorNullAsDefault;
import jetbrick.template.parser.ast.AstOperatorUnary;
import jetbrick.template.parser.ast.AstStatement;
import jetbrick.template.parser.ast.AstStatementList;
import jetbrick.template.parser.ast.AstTemplate;
import jetbrick.template.parser.ast.AstTernaryOperator;
import jetbrick.template.parser.ast.AstTernarySimplifyOperator;
import jetbrick.template.parser.ast.AstText;
import jetbrick.template.parser.ast.AstType;
import jetbrick.template.parser.ast.AstValue;
import jetbrick.template.parser.ast.AstValueEscaped;
import jetbrick.template.parser.ast.Position;
import jetbrick.template.runtime.parser.grammer.JetTemplateParser;
import jetbrick.template.runtime.parser.grammer.JetTemplateParserVisitor;
import jetbrick.util.JavaKeywordsUtils;
import jetbrick.util.StringEscapeUtils;
import jetbrick.util.StringUtils;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class AstCodeVisitor
extends AbstractParseTreeVisitor<AstNode>
implements JetTemplateParserVisitor<AstNode> {
    private final ParserContext parseCtx;

    public AstCodeVisitor(ParserContext parseCtx) {
        this.parseCtx = parseCtx;
    }

    @Override
    public AstTemplate visitTemplate(JetTemplateParser.TemplateContext ctx) {
        AstStatementList statements = (AstStatementList)this.accept(ctx.getChild(0));
        return new AstTemplate(statements);
    }

    @Override
    public AstStatementList visitBlock(JetTemplateParser.BlockContext ctx) {
        int block;
        List<AstStatement> statements = this.accept(ctx.children);
        ParserRuleContext parent = ctx.getParent();
        if (parent instanceof JetTemplateParser.TemplateContext) {
            block = 1;
        } else if (parent instanceof JetTemplateParser.Directive_forContext) {
            block = 2;
        } else if (parent instanceof JetTemplateParser.Directive_ifContext) {
            block = 3;
        } else if (parent instanceof JetTemplateParser.Directive_elseifContext) {
            block = 4;
        } else if (parent instanceof JetTemplateParser.Directive_elseContext) {
            block = 5;
        } else if (parent instanceof JetTemplateParser.Directive_macroContext) {
            block = 6;
        } else if (parent instanceof JetTemplateParser.Directive_tagContext) {
            block = 7;
        } else {
            throw new UnsupportedOperationException();
        }
        return new AstStatementList(statements, block, this.parseCtx);
    }

    @Override
    public AstText visitText(JetTemplateParser.TextContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        String text = token.getText();
        switch (token.getType()) {
            case 4: {
                text = text.substring(3, text.length() - 3);
                break;
            }
            case 5: {
                text = text.substring(1);
            }
        }
        return new AstText(text, token.getLine());
    }

    @Override
    public AstNode visitValue(JetTemplateParser.ValueContext ctx) {
        AstExpression expression = (AstExpression)this.accept((ParseTree)ctx.expression());
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        if (token.getType() == 8) {
            return new AstValueEscaped(expression);
        }
        return new AstValue(expression);
    }

    @Override
    public AstNode visitDirective(JetTemplateParser.DirectiveContext ctx) {
        return (AstNode)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public AstNode visitDirective_options(JetTemplateParser.Directive_optionsContext ctx) {
        this.accept(ctx.directive_options_expression());
        return AstDirectiveNoop.INSTANCE;
    }

    @Override
    public AstNode visitDirective_options_expression(JetTemplateParser.Directive_options_expressionContext ctx) {
        ParseTree nameNode = ctx.getChild(0);
        ParseTree valueNode = ctx.getChild(2);
        String name = nameNode.getText();
        Object value = ((AstConstant)this.accept(valueNode)).getValue();
        boolean invalidName = false;
        if ("import".equals(name)) {
            if (value instanceof String) {
                this.parseCtx.importClass((String)value);
                return null;
            }
        } else if ("loadmacro".equals(name)) {
            if (value instanceof String) {
                this.parseCtx.loadMacroFile((String)value);
                return null;
            }
        } else if ("strict".equals(name)) {
            if (value instanceof Boolean) {
                this.parseCtx.setStrict((Boolean)value);
                return null;
            }
        } else if ("safecall".equals(name)) {
            if (value instanceof Boolean) {
                this.parseCtx.setSafecall((Boolean)value);
                return null;
            }
        } else if ("trimLeadingWhitespaces".equals(name)) {
            if (value instanceof Boolean) {
                this.parseCtx.setTrimLeadingWhitespaces((Boolean)value);
                return null;
            }
        } else {
            invalidName = true;
        }
        if (invalidName) {
            throw new SyntaxException("#option name is unknown: %s", name).set(this.pos(nameNode));
        }
        throw new SyntaxException("#option value is invalid: %s", name).set(this.pos(valueNode));
    }

    @Override
    public AstNode visitDirective_define(JetTemplateParser.Directive_defineContext ctx) {
        this.accept(ctx.directive_define_expression());
        return AstDirectiveNoop.INSTANCE;
    }

    @Override
    public AstNode visitDirective_define_expression(JetTemplateParser.Directive_define_expressionContext ctx) {
        AstType type = (AstType)this.accept((ParseTree)ctx.type());
        String identifier = ctx.IDENTIFIER().getText();
        this.validateIdentifier(identifier, true, (ParseTree)ctx.IDENTIFIER());
        Class<?> cls = this.resolveClass(type);
        try {
            this.parseCtx.defineSymbol(identifier, cls);
        }
        catch (IllegalStateException e) {
            throw new SyntaxException(e).set(this.pos((Object)ctx));
        }
        return null;
    }

    @Override
    public AstStatementList visitDirective_set(JetTemplateParser.Directive_setContext ctx) {
        List<AstStatement> statements = this.accept(ctx.directive_set_expression());
        return new AstStatementList(statements, 8, this.parseCtx);
    }

    @Override
    public AstStatement visitDirective_set_expression(JetTemplateParser.Directive_set_expressionContext ctx) {
        AstType type = (AstType)this.accept((ParseTree)ctx.type());
        String identifier = ctx.IDENTIFIER().getText();
        AstExpression expression = (AstExpression)this.accept((ParseTree)ctx.expression());
        this.validateIdentifier(identifier, true, (ParseTree)ctx.IDENTIFIER());
        if (type != null) {
            Class<?> cls = this.resolveClass(type);
            try {
                this.parseCtx.defineSymbol(identifier, cls, true);
            }
            catch (IllegalStateException e) {
                throw new SyntaxException(e).set(this.pos((Object)ctx));
            }
        }
        try {
            this.parseCtx.useSymbol(identifier);
        }
        catch (IllegalStateException e) {
            throw new SyntaxException(e).set(this.pos((Object)ctx));
        }
        return new AstDirectiveSet(identifier, expression, this.pos((Object)ctx));
    }

    @Override
    public AstDirectiveIf visitDirective_if(JetTemplateParser.Directive_ifContext ctx) {
        AstExpression conditionExpression = (AstExpression)this.accept(ctx.getChild(1));
        AstStatementList thenStatement = (AstStatementList)this.accept(ctx.getChild(3));
        AstStatement elseStatement = (AstStatement)this.accept((ParseTree)ctx.directive_else());
        if (elseStatement == null) {
            elseStatement = (AstStatement)this.accept((ParseTree)ctx.directive_elseif());
        }
        return new AstDirectiveIf(conditionExpression, thenStatement, elseStatement, this.pos((Object)ctx));
    }

    @Override
    public AstDirectiveIf visitDirective_elseif(JetTemplateParser.Directive_elseifContext ctx) {
        AstExpression conditionExpression = (AstExpression)this.accept(ctx.getChild(1));
        AstStatementList thenStatement = (AstStatementList)this.accept(ctx.getChild(3));
        AstStatement elseStatement = (AstStatement)this.accept((ParseTree)ctx.directive_else());
        if (elseStatement == null) {
            elseStatement = (AstStatement)this.accept((ParseTree)ctx.directive_elseif());
        }
        return new AstDirectiveIf(conditionExpression, thenStatement, elseStatement, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitDirective_else(JetTemplateParser.Directive_elseContext ctx) {
        return (AstNode)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public AstDirectiveFor visitDirective_for(JetTemplateParser.Directive_forContext ctx) {
        AstType type = (AstType)this.accept((ParseTree)ctx.type());
        String identifier = ctx.IDENTIFIER().getText();
        this.validateIdentifier(identifier, true, (ParseTree)ctx.IDENTIFIER());
        Class<?> cls = null;
        if (type != null) {
            cls = this.resolveClass(type);
        }
        try {
            this.parseCtx.defineSymbol(identifier, cls, true);
        }
        catch (IllegalStateException e) {
            throw new SyntaxException(e).set(this.pos((Object)ctx));
        }
        AstExpression expression = (AstExpression)this.accept((ParseTree)ctx.expression());
        AstStatementList statement = (AstStatementList)this.accept((ParseTree)ctx.block());
        AstStatementList elseStatement = (AstStatementList)this.accept((ParseTree)ctx.directive_else());
        return new AstDirectiveFor(identifier, expression, statement, elseStatement, this.pos((Object)ctx));
    }

    @Override
    public AstDirectiveBreak visitDirective_break(JetTemplateParser.Directive_breakContext ctx) {
        this.validateInsideOfDirectiveFor(ctx, "#break");
        AstExpression expression = (AstExpression)this.accept((ParseTree)ctx.expression());
        return new AstDirectiveBreak(expression, this.pos((Object)ctx));
    }

    @Override
    public AstDirectiveContinue visitDirective_continue(JetTemplateParser.Directive_continueContext ctx) {
        this.validateInsideOfDirectiveFor(ctx, "#continue");
        AstExpression expression = (AstExpression)this.accept((ParseTree)ctx.expression());
        return new AstDirectiveContinue(expression, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitDirective_stop(JetTemplateParser.Directive_stopContext ctx) {
        AstExpression expression = (AstExpression)this.accept((ParseTree)ctx.expression());
        return new AstDirectiveStop(expression, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitDirective_return(JetTemplateParser.Directive_returnContext ctx) {
        AstExpression expression = (AstExpression)this.accept(ctx.getChild(1));
        return new AstDirectiveReturn(expression, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitDirective_include(JetTemplateParser.Directive_includeContext ctx) {
        List expressions = this.accept(ctx.expression());
        AstExpression fileExpression = (AstExpression)expressions.get(0);
        AstExpression parametersExpression = null;
        String returnName = null;
        switch (expressions.size()) {
            case 1: {
                break;
            }
            case 2: {
                AstExpression expr = (AstExpression)expressions.get(1);
                if (expr instanceof AstConstantMap) {
                    parametersExpression = expr;
                    break;
                }
                if (expr instanceof AstConstant) {
                    Object value = ((AstConstant)expr).getValue();
                    if (value instanceof String) {
                        returnName = (String)value;
                        break;
                    }
                    throw new SyntaxException("type mismatch: the %s argument cannot convert from %s to %s", "2nd", value.getClass(), "String").set(this.pos(expr));
                }
                parametersExpression = expr;
                break;
            }
            case 3: {
                parametersExpression = (AstExpression)expressions.get(1);
                AstExpression expr = (AstExpression)expressions.get(2);
                Object value = ((AstConstant)expr).getValue();
                if (value instanceof String) {
                    returnName = (String)value;
                    break;
                }
                throw new SyntaxException("type mismatch: the %s argument cannot convert from %s to %s", "3rd", value.getClass(), "String").set(this.pos(expr));
            }
            default: {
                throw new SyntaxException("arguments not match").set(this.pos(expressions.get(3)));
            }
        }
        return new AstDirectiveInclude(fileExpression, parametersExpression, returnName, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitDirective_tag(JetTemplateParser.Directive_tagContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        Position position = new Position(token.getLine(), token.getCharPositionInLine() + 5);
        String name = ctx.getChild(0).getText();
        name = StringUtils.substringBetween((String)name, (String)" ", (String)"(").trim();
        AstExpressionList expressionList = (AstExpressionList)this.accept((ParseTree)ctx.expression_list());
        AstStatementList block = (AstStatementList)this.accept((ParseTree)ctx.block());
        return new AstDirectiveTag(name, expressionList, block, position);
    }

    @Override
    public AstNode visitDirective_call(JetTemplateParser.Directive_callContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        Position position = new Position(token.getLine(), token.getCharPositionInLine() + 6);
        String name = ctx.getChild(0).getText();
        name = StringUtils.substringBetween((String)name, (String)" ", (String)"(").trim();
        AstExpressionList expressionList = (AstExpressionList)this.accept((ParseTree)ctx.expression_list());
        return new AstDirectiveCall(name, expressionList, position);
    }

    @Override
    public AstNode visitDirective_macro(JetTemplateParser.Directive_macroContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        Position position = new Position(token.getLine(), token.getCharPositionInLine() + 7);
        String name = token.getText();
        name = StringUtils.substringBetween((String)name, (String)" ", (String)"(").trim();
        this.parseCtx.enterMacros();
        this.accept((ParseTree)ctx.directive_macro_arguments());
        List<String> argumentNames = this.parseCtx.getMacroArgumentNames();
        AstStatementList block = (AstStatementList)this.accept((ParseTree)ctx.block());
        AstDirectiveMacro macro = new AstDirectiveMacro(name, argumentNames, this.parseCtx.getSymbols(), block, position);
        try {
            this.parseCtx.defineMacro(macro);
        }
        catch (IllegalStateException e) {
            throw new SyntaxException(e).set(position);
        }
        this.parseCtx.exitMacros();
        return AstDirectiveNoop.INSTANCE;
    }

    @Override
    public AstNode visitDirective_macro_arguments(JetTemplateParser.Directive_macro_argumentsContext ctx) {
        int count = ctx.getChildCount();
        for (int i = 0; i < count; ++i) {
            ParseTree node = ctx.getChild(i++);
            Class<?> cls = null;
            if (node instanceof JetTemplateParser.TypeContext) {
                AstType type = (AstType)this.accept(node);
                cls = this.resolveClass(type);
                node = ctx.getChild(i++);
            }
            String name = node.getText();
            try {
                this.parseCtx.defineSymbol(name, cls);
                continue;
            }
            catch (IllegalStateException e) {
                throw new SyntaxException(e).set(this.pos(node));
            }
        }
        return null;
    }

    @Override
    public AstNode visitDirective_invalid(JetTemplateParser.Directive_invalidContext ctx) {
        throw new SyntaxException("arguments is missing: %s", ctx.getText()).set(this.pos((Object)ctx));
    }

    @Override
    public AstNode visitExpression_primary(JetTemplateParser.Expression_primaryContext ctx) {
        return (AstNode)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public AstNode visitExpression_constant(JetTemplateParser.Expression_constantContext ctx) {
        return (AstNode)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public AstExpression visitExpression_array_list(JetTemplateParser.Expression_array_listContext ctx) {
        AstExpressionList expressionList = (AstExpressionList)this.accept(ctx.getChild(1));
        if (expressionList == null) {
            return new AstConstant(Collections.emptyList(), this.pos((Object)ctx));
        }
        return new AstConstantList(expressionList, this.pos((Object)ctx));
    }

    @Override
    public AstExpression visitExpression_hash_map(JetTemplateParser.Expression_hash_mapContext ctx) {
        List<AstConstantMapEntry> entries = this.accept(ctx.hash_map_entry());
        if (entries == null || entries.isEmpty()) {
            return new AstConstant(Collections.emptyMap(), this.pos((Object)ctx));
        }
        return new AstConstantMap(entries, this.pos((Object)ctx));
    }

    @Override
    public AstConstantMapEntry visitHash_map_entry(JetTemplateParser.Hash_map_entryContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        String name = token.getText();
        switch (token.getType()) {
            case 86: 
            case 87: {
                name = this.getJavaString(token.getText(), ctx);
            }
        }
        AstExpression valueExpression = (AstExpression)this.accept(ctx.getChild(2));
        return new AstConstantMapEntry(name, valueExpression, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitExpression_unary_operator(JetTemplateParser.Expression_unary_operatorContext ctx) {
        Position position = this.pos((Object)ctx);
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        AstExpression expression = (AstExpression)this.accept(ctx.getChild(1));
        switch (token.getType()) {
            case 65: {
                return new AstOperatorUnary(1, expression, position);
            }
            case 66: {
                return new AstOperatorUnary(2, expression, position);
            }
            case 64: {
                return new AstOperatorEquals(23, expression, null, position);
            }
            case 72: {
                return new AstOperatorUnary(22, expression, position);
            }
        }
        throw new SyntaxException("unreachable code").set(position);
    }

    @Override
    public AstNode visitExpression_binary_operator(JetTemplateParser.Expression_binary_operatorContext ctx) {
        Position position = this.pos(ctx, 1);
        Token token = ((TerminalNode)ctx.getChild(1)).getSymbol();
        AstExpression lhs = (AstExpression)this.accept(ctx.getChild(0));
        AstExpression rhs = (AstExpression)this.accept(ctx.getChild(ctx.getChildCount() - 1));
        switch (token.getType()) {
            case 65: {
                return new AstOperatorBinary(1, lhs, rhs, position);
            }
            case 66: {
                return new AstOperatorBinary(2, lhs, rhs, position);
            }
            case 67: {
                return new AstOperatorBinary(3, lhs, rhs, position);
            }
            case 68: {
                return new AstOperatorBinary(4, lhs, rhs, position);
            }
            case 69: {
                return new AstOperatorBinary(5, lhs, rhs, position);
            }
            case 74: {
                return new AstOperatorBinary(9, lhs, rhs, position);
            }
            case 75: {
                return new AstOperatorBinary(10, lhs, rhs, position);
            }
            case 76: {
                return new AstOperatorBinary(11, lhs, rhs, position);
            }
            case 70: {
                return new AstOperatorBinary(6, lhs, rhs, position);
            }
            case 71: {
                return new AstOperatorBinary(7, lhs, rhs, position);
            }
            case 73: {
                return new AstOperatorBinary(8, lhs, rhs, position);
            }
            case 59: {
                return new AstOperatorBinary(12, lhs, rhs, position);
            }
            case 61: {
                return new AstOperatorBinary(13, lhs, rhs, position);
            }
            case 58: {
                return new AstOperatorBinary(14, lhs, rhs, position);
            }
            case 54: {
                return new AstOperatorEquals(18, lhs, rhs, position);
            }
            case 55: {
                return new AstOperatorEquals(19, lhs, rhs, position);
            }
            case 60: {
                return new AstOperatorBinary(15, lhs, rhs, position);
            }
            case 56: {
                return new AstOperatorEquals(16, lhs, rhs, position);
            }
            case 57: {
                return new AstOperatorEquals(17, lhs, rhs, position);
            }
            case 62: {
                return new AstOperatorEquals(20, lhs, rhs, position);
            }
            case 63: {
                return new AstOperatorEquals(21, lhs, rhs, position);
            }
        }
        throw new SyntaxException("unreachable code").set(position);
    }

    @Override
    public AstNode visitExpression_nullsafe_operator(JetTemplateParser.Expression_nullsafe_operatorContext ctx) {
        this.parseCtx.setNullSafe(true);
        AstExpression objectExpression = (AstExpression)this.accept(ctx.getChild(0));
        this.parseCtx.setNullSafe(false);
        AstExpression defaultExpression = (AstExpression)this.accept(ctx.getChild(2));
        return new AstOperatorNullAsDefault(objectExpression, defaultExpression, this.pos(ctx, 1));
    }

    @Override
    public AstNode visitExpression_ternary_operator(JetTemplateParser.Expression_ternary_operatorContext ctx) {
        if (ctx.getChildCount() == 5) {
            AstExpression conditionExpression = (AstExpression)this.accept(ctx.getChild(0));
            AstExpression trueExpression = (AstExpression)this.accept(ctx.getChild(2));
            AstExpression falseExpression = (AstExpression)this.accept(ctx.getChild(4));
            return new AstTernaryOperator(conditionExpression, trueExpression, falseExpression, this.pos(ctx, 1));
        }
        AstExpression objectExpression = (AstExpression)this.accept(ctx.getChild(0));
        AstExpression defaultExpression = (AstExpression)this.accept(ctx.getChild(3));
        return new AstTernarySimplifyOperator(objectExpression, defaultExpression, this.pos(ctx, 1));
    }

    @Override
    public AstNode visitExpression_instanceof(JetTemplateParser.Expression_instanceofContext ctx) {
        AstExpression expression = (AstExpression)this.accept(ctx.getChild(0));
        AstType type = (AstType)this.accept(ctx.getChild(2));
        Class<?> cls = this.resolveClass(type);
        return new AstOperatorInstanceof(expression, cls, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitExpression_new_object(JetTemplateParser.Expression_new_objectContext ctx) {
        AstType type = (AstType)this.accept(ctx.getChild(1));
        AstExpressionList argumentList = (AstExpressionList)this.accept((ParseTree)ctx.expression_list());
        Class<?> cls = this.resolveClass(type);
        return new AstInvokeNewObject(cls, argumentList, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitExpression_new_array(JetTemplateParser.Expression_new_arrayContext ctx) {
        AstType type = (AstType)this.accept(ctx.getChild(1));
        List<AstExpression> expressions = this.accept(ctx.expression());
        Class<?> cls = this.resolveClass(type);
        return new AstInvokeNewArray(cls, expressions, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitExpression_field(JetTemplateParser.Expression_fieldContext ctx) {
        AstExpression objectExpression = (AstExpression)this.accept(ctx.getChild(0));
        String name = ctx.getChild(2).getText();
        return new AstInvokeField(objectExpression, name, this.parseCtx.isNullSafe(), this.pos(ctx, 1));
    }

    @Override
    public AstNode visitExpression_field_static(JetTemplateParser.Expression_field_staticContext ctx) {
        AstType type = (AstType)this.accept(ctx.getChild(0));
        String name = ctx.getChild(2).getText();
        Class<?> cls = this.resolveClass(type);
        return new AstInvokeFieldStatic(cls, name, this.pos(ctx, 1));
    }

    @Override
    public AstNode visitExpression_method(JetTemplateParser.Expression_methodContext ctx) {
        AstExpression objectExpression = (AstExpression)this.accept(ctx.getChild(0));
        String name = ctx.getChild(2).getText();
        AstExpressionList argumentList = (AstExpressionList)this.accept((ParseTree)ctx.expression_list());
        return new AstInvokeMethod(objectExpression, name, argumentList, this.parseCtx.isNullSafe(), this.pos(ctx, 1));
    }

    @Override
    public AstNode visitExpression_method_static(JetTemplateParser.Expression_method_staticContext ctx) {
        AstType type = (AstType)this.accept(ctx.getChild(0));
        String name = ctx.getChild(2).getText();
        AstExpressionList argumentList = (AstExpressionList)this.accept((ParseTree)ctx.expression_list());
        Class<?> cls = this.resolveClass(type);
        return new AstInvokeMethodStatic(cls, name, argumentList, this.pos(ctx, 1));
    }

    @Override
    public AstNode visitExpression_index_get(JetTemplateParser.Expression_index_getContext ctx) {
        AstExpression objectExpression = (AstExpression)this.accept(ctx.getChild(0));
        AstExpression indexExpression = (AstExpression)this.accept(ctx.getChild(2));
        return new AstInvokeIndexGet(objectExpression, indexExpression, this.parseCtx.isNullSafe(), this.pos(ctx, 1));
    }

    @Override
    public AstNode visitExpression_function(JetTemplateParser.Expression_functionContext ctx) {
        String name = ctx.getChild(0).getText();
        AstExpressionList argumentList = (AstExpressionList)this.accept((ParseTree)ctx.expression_list());
        return new AstInvokeFunction(name, argumentList, this.pos((Object)ctx));
    }

    @Override
    public AstNode visitExpression_identifier(JetTemplateParser.Expression_identifierContext ctx) {
        return (AstNode)ctx.getChild(0).accept((ParseTreeVisitor)this);
    }

    @Override
    public AstIdentifier visitIdentifier(JetTemplateParser.IdentifierContext ctx) {
        String name = ctx.getChild(0).getText();
        this.validateIdentifier(name, false, (ParseTree)ctx);
        if ("for".equals(name)) {
            this.validateInsideOfDirectiveFor(ctx, "Local variable `for`");
        }
        return new AstIdentifier(name, this.pos((Object)ctx));
    }

    @Override
    public AstConstant visitConstant(JetTemplateParser.ConstantContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        String text = token.getText();
        int length = text.length();
        int type = token.getType();
        switch (type) {
            case 86: 
            case 87: {
                String value = this.getJavaString(text, ctx);
                return new AstConstant(value, this.pos((Object)ctx));
            }
            case 83: 
            case 84: 
            case 85: {
                Number value;
                int radix;
                char suffix = text.charAt(length - 1);
                if (type == 84) {
                    radix = 16;
                    if (suffix == 'l' || suffix == 'L') {
                        text = text.substring(2, length - 1);
                    } else {
                        text = text.substring(2);
                        suffix = '\u0000';
                    }
                } else {
                    radix = 10;
                    if (suffix > '9') {
                        text = text.substring(0, length - 1);
                    }
                }
                switch (suffix) {
                    case 'L': 
                    case 'l': {
                        value = Long.valueOf(text, radix);
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        value = Float.valueOf(text);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        value = Double.valueOf(text);
                        break;
                    }
                    default: {
                        value = type == 85 ? (Number)Double.valueOf(text) : (Number)Integer.valueOf(text, radix);
                    }
                }
                return new AstConstant(value, this.pos((Object)ctx));
            }
            case 79: {
                return new AstConstant(Boolean.TRUE, this.pos((Object)ctx));
            }
            case 80: {
                return new AstConstant(Boolean.FALSE, this.pos((Object)ctx));
            }
            case 81: {
                return new AstConstant(null, this.pos((Object)ctx));
            }
        }
        throw new SyntaxException("unreachable code").set(this.pos((Object)ctx));
    }

    @Override
    public AstExpressionList visitExpression_list(JetTemplateParser.Expression_listContext ctx) {
        List<AstExpression> expression_list = this.accept(ctx.expression());
        return new AstExpressionList(expression_list, this.pos((Object)ctx));
    }

    @Override
    public AstType visitType(JetTemplateParser.TypeContext ctx) {
        String className = StringUtils.deleteWhitespace((String)ctx.getText());
        return new AstType(className, this.pos((Object)ctx));
    }

    private Class<?> resolveClass(AstType type) {
        Class<?> cls = this.parseCtx.resolveClass(type.getClassName());
        if (cls == null) {
            throw new SyntaxException("cannot resolve class: %s", type.getClassName()).set(this.pos(type));
        }
        return cls;
    }

    private <T extends AstNode> T accept(ParseTree node) {
        if (node != null) {
            return (T)((AstNode)node.accept((ParseTreeVisitor)this));
        }
        return null;
    }

    private <T extends AstNode> List<T> accept(List<? extends ParseTree> nodes) {
        if (nodes != null) {
            int size = nodes.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            ArrayList<AstNode> results = new ArrayList<AstNode>(size);
            for (ParseTree parseTree : nodes) {
                AstNode ast = (AstNode)parseTree.accept((ParseTreeVisitor)this);
                if (ast == null) continue;
                results.add(ast);
            }
            return results;
        }
        return null;
    }

    private void validateIdentifier(String name, boolean defining, ParseTree node) {
        if ("for".equals(name)) {
            if (defining) {
                throw new SyntaxException("syntax error on token `%s`, It is a reserved/keyword identifier", name).set(this.pos(node));
            }
        } else {
            if (JavaKeywordsUtils.isKeyword((String)name)) {
                throw new SyntaxException("syntax error on token `%s`, It is a reserved/keyword identifier", name).set(this.pos(node));
            }
            if (name.startsWith("$")) {
                throw new SyntaxException("local variable `%s` cannot start with '$', it is a reserved identifier", name).set(this.pos(node));
            }
        }
        if (!defining) {
            try {
                this.parseCtx.useSymbol(name);
            }
            catch (IllegalStateException e) {
                throw new SyntaxException(e).set(this.pos(node));
            }
        }
    }

    private void validateInsideOfDirectiveFor(ParserRuleContext ctx, String name) {
        for (ParserRuleContext p = ctx.getParent(); p != null; p = p.getParent()) {
            if (p instanceof JetTemplateParser.Directive_forContext) {
                return;
            }
            if (!(p instanceof JetTemplateParser.Directive_elseContext)) continue;
            p = p.getParent();
        }
        throw new SyntaxException("`%s` cannot be used outside of `#for(...)`", name).set(this.pos(ctx));
    }

    private String getJavaString(String text, ParserRuleContext ctx) {
        String value = text;
        value = value.substring(1, value.length() - 1);
        try {
            value = StringEscapeUtils.unescapeJava((String)value);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SyntaxException("invalid unicode in string constant").set(this.pos(ctx));
        }
        return value;
    }

    private Position pos(ParserRuleContext ctx, int childIndex) {
        ParseTree node = ctx.getChild(childIndex);
        if (node instanceof TerminalNode) {
            Token token = ((TerminalNode)node).getSymbol();
            return new Position(token.getLine(), token.getCharPositionInLine());
        }
        if (node instanceof ParserRuleContext) {
            Token token = ctx.getStart();
            return new Position(token.getLine(), token.getCharPositionInLine());
        }
        throw new UnsupportedOperationException();
    }

    private Position pos(Object ctx) {
        Token token = null;
        if (ctx instanceof ParserRuleContext) {
            token = ((ParserRuleContext)ctx).getStart();
        } else if (ctx instanceof TerminalNode) {
            token = ((TerminalNode)ctx).getSymbol();
        } else if (ctx instanceof Token) {
            token = (Token)ctx;
        } else {
            if (ctx instanceof AstExpression) {
                return ((AstExpression)ctx).getPosition();
            }
            if (ctx instanceof AstType) {
                return ((AstType)ctx).getPosition();
            }
        }
        if (token != null) {
            return new Position(token.getLine(), token.getCharPositionInLine());
        }
        throw new UnsupportedOperationException();
    }
}

