/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrick.io.IoUtils;
import jetbrick.template.JetSecurityManager;
import jetbrick.util.StringUtils;

public final class JetSecurityManagerImpl
implements JetSecurityManager {
    private final Set<String> blackList = new HashSet<String>();
    private final Set<String> whiteList = new HashSet<String>();
    private boolean disallowStaticMethod = false;
    private boolean disallowStaticField = false;
    private boolean disallowConstructor = false;

    public void setConfigFile(String configFile) {
        String[] lines;
        String fileContent = IoUtils.toString((File)new File(configFile), (String)"utf-8");
        for (String line : lines = StringUtils.split((String)fileContent, (char)'\n')) {
            this.addList(line);
        }
    }

    public void setNameList(List<String> nameList) {
        for (String line : nameList) {
            this.addList(line);
        }
    }

    public void setDisallowConstructor(boolean disallowConstructor) {
        this.disallowConstructor = disallowConstructor;
    }

    public void setDisallowStaticMethod(boolean disallowStaticMethod) {
        this.disallowStaticMethod = disallowStaticMethod;
    }

    public void setDisallowStaticField(boolean disallowStaticField) {
        this.disallowStaticField = disallowStaticField;
    }

    private void addList(String line) {
        if ((line = line.trim()).length() == 0) {
            return;
        }
        char c = line.charAt(0);
        if (c == '+') {
            this.whiteList.add(line.substring(1));
        } else if (c == '-') {
            this.blackList.add(line.substring(1));
        } else {
            this.whiteList.add(line);
        }
    }

    private void checkAccess(String fullName) throws AccessControlException {
        String name = fullName;
        while (true) {
            if (this.whiteList.contains(name)) {
                return;
            }
            if (this.blackList.contains(name)) {
                throw new AccessControlException("access denied for '" + fullName + "' because of '" + name + "' is in blacklist.");
            }
            int ipos = name.lastIndexOf(46);
            if (ipos == -1) break;
            name = name.substring(0, ipos);
        }
    }

    @Override
    public void checkAccess(Class<?> cls) {
        this.checkAccess(cls.getName());
    }

    @Override
    public void checkAccess(Constructor<?> constructor) throws AccessControlException {
        String fullName = constructor.getDeclaringClass().getName() + ".<init>";
        if (this.disallowConstructor) {
            throw new AccessControlException("access denied for constructor: " + fullName);
        }
        this.checkAccess(fullName);
    }

    @Override
    public void checkAccess(Method method) throws AccessControlException {
        String fullName = method.getDeclaringClass().getName() + '.' + method.getName();
        if (this.disallowStaticMethod && Modifier.isStatic(method.getModifiers())) {
            throw new AccessControlException("access denied for static method: " + fullName);
        }
        this.checkAccess(fullName);
    }

    @Override
    public void checkAccess(Field field) throws AccessControlException {
        String fullName = field.getDeclaringClass().getName() + '.' + field.getName();
        if (this.disallowStaticField && Modifier.isStatic(field.getModifiers())) {
            throw new AccessControlException("access denied for static field: " + fullName);
        }
        this.checkAccess(fullName);
    }
}

