/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.context.ReadContext;
import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class TimestampReadConverter
extends AbstractReadConverter<Timestamp> {
    @Override
    protected Timestamp doConvert(ReadContext<?> readContext) {
        String v = readContext.getVal();
        if (this.isDateNumber(v)) {
            long time = Long.parseLong(v);
            return new Timestamp(time);
        }
        String dateFormatPattern = this.getDateFormatPattern(readContext);
        SimpleDateFormat sdf = this.getSimpleDateFormat(dateFormatPattern);
        try {
            return new Timestamp(sdf.parse(v).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

