/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.SheetMetaData;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XSSFSheetMetaDataXMLHandler
extends DefaultHandler {
    private int nextRowNum;
    private int rowNum = -1;
    private final SheetMetaData sheetMetaData;

    public XSSFSheetMetaDataXMLHandler(SheetMetaData sheetMetaData) {
        this.sheetMetaData = sheetMetaData;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("row".equals(localName)) {
            String rowNumStr = attributes.getValue("r");
            this.rowNum = rowNumStr != null ? Integer.parseInt(rowNumStr) - 1 : this.nextRowNum;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("row".equals(localName)) {
            this.nextRowNum = this.rowNum + 1;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.rowNum > -1) {
            this.sheetMetaData.setLastRowNum(this.rowNum + 1);
        }
    }
}

