/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.PromptContainer;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.Prompt;
import com.github.liaochong.myexcel.core.constant.FileType;
import com.github.liaochong.myexcel.core.constant.LinkType;
import com.github.liaochong.myexcel.core.converter.CustomWriteConverter;
import com.github.liaochong.myexcel.core.parser.DropdownList;
import com.github.liaochong.myexcel.core.parser.Image;
import com.github.liaochong.myexcel.utils.StringUtil;

public final class ExcelColumnMapping {
    public String title;
    public int order;
    public int index;
    public Class<?>[] groups;
    public String defaultValue;
    public int width;
    public boolean convertToString;
    public String format;
    public String[] style;
    public LinkType linkType;
    public String mapping;
    public Class<? extends CustomWriteConverter> customWriteConverter;
    public FileType fileType;
    public boolean formula;
    public PromptContainer promptContainer;
    public Image image;
    public DropdownList dropdownList;

    public static ExcelColumnMapping mapping(ExcelColumn excelColumn) {
        com.github.liaochong.myexcel.core.annotation.DropdownList dr;
        com.github.liaochong.myexcel.core.annotation.Image image;
        ExcelColumnMapping result = new ExcelColumnMapping();
        result.title = excelColumn.title();
        result.order = excelColumn.order();
        result.index = excelColumn.index();
        result.groups = excelColumn.groups();
        result.defaultValue = excelColumn.defaultValue();
        result.width = excelColumn.width();
        result.convertToString = excelColumn.convertToString();
        result.format = !excelColumn.format().isEmpty() ? excelColumn.format() : (!excelColumn.dateFormatPattern().isEmpty() ? excelColumn.dateFormatPattern() : (!excelColumn.decimalFormat().isEmpty() ? excelColumn.decimalFormat() : ""));
        result.style = excelColumn.style();
        result.linkType = excelColumn.linkType();
        result.mapping = excelColumn.mapping();
        result.fileType = excelColumn.fileType();
        result.formula = excelColumn.formula();
        result.customWriteConverter = excelColumn.writeConverter();
        Prompt prompt = excelColumn.prompt();
        if (StringUtil.isNotBlank(prompt.text())) {
            PromptContainer promptContainer = new PromptContainer();
            promptContainer.title = prompt.title();
            promptContainer.text = prompt.text();
            result.promptContainer = promptContainer;
        }
        if ((image = excelColumn.image()).scaleX() > 0.0 && image.scaleY() > 0.0) {
            result.image.setScaleX(image.scaleX());
            result.image.setScaleY(image.scaleY());
            result.image = new Image();
        }
        if (image.marginTop() > 0) {
            if (result.image == null) {
                result.image = new Image();
            }
            result.image.setMarginTop(image.marginTop());
        }
        if (image.marginLeft() > 0) {
            if (result.image == null) {
                result.image = new Image();
            }
            result.image.setMarginLeft(image.marginLeft());
        }
        if (image.width() > 0) {
            if (result.image == null) {
                result.image = new Image();
            }
            result.image.setWidth(image.width());
        }
        if (image.height() > 0) {
            if (result.image == null) {
                result.image = new Image();
            }
            result.image.setHeight(image.height());
        }
        if (StringUtil.isNotBlank((dr = excelColumn.dropdownList()).name()) || StringUtil.isNotBlank(dr.parent())) {
            DropdownList drList = new DropdownList();
            drList.setName(dr.name());
            drList.setParent(dr.parent());
            result.dropdownList = drList;
        }
        return result;
    }
}

