/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.DigitalSignatureTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.KerningTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.MemoryTTFDataStream;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.RAFDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.VerticalHeaderTable;
import org.apache.fontbox.ttf.VerticalMetricsTable;
import org.apache.fontbox.ttf.VerticalOriginTable;

public class TTFParser {
    private boolean isEmbedded = false;
    private boolean parseOnDemandOnly = false;

    public TTFParser() {
        this(false);
    }

    public TTFParser(boolean isEmbedded) {
        this(isEmbedded, false);
    }

    public TTFParser(boolean isEmbedded, boolean parseOnDemand) {
        this.isEmbedded = isEmbedded;
        this.parseOnDemandOnly = parseOnDemand;
    }

    public TrueTypeFont parse(String ttfFile) throws IOException {
        return this.parse(new File(ttfFile));
    }

    public TrueTypeFont parse(File ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        try {
            return this.parse(raf);
        }
        catch (IOException ex) {
            raf.close();
            throw ex;
        }
    }

    public TrueTypeFont parse(InputStream inputStream) throws IOException {
        return this.parse(new MemoryTTFDataStream(inputStream));
    }

    public TrueTypeFont parseEmbedded(InputStream inputStream) throws IOException {
        this.isEmbedded = true;
        return this.parse(new MemoryTTFDataStream(inputStream));
    }

    TrueTypeFont parse(TTFDataStream raf) throws IOException {
        TrueTypeFont font = this.newFont(raf);
        font.setVersion(raf.read32Fixed());
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        for (int i = 0; i < numberOfTables; ++i) {
            TTFTable table = this.readTableDirectory(font, raf);
            if (table == null) continue;
            font.addTable(table);
        }
        if (!this.parseOnDemandOnly) {
            this.parseTables(font);
        }
        return font;
    }

    TrueTypeFont newFont(TTFDataStream raf) {
        return new TrueTypeFont(raf);
    }

    private void parseTables(TrueTypeFont font) throws IOException {
        for (TTFTable table : font.getTables()) {
            if (table.getInitialized()) continue;
            font.readTable(table);
        }
        boolean isPostScript = this.allowCFF() && font.tables.containsKey("CFF ");
        HeaderTable head = font.getHeader();
        if (head == null) {
            throw new IOException("head is mandatory");
        }
        HorizontalHeaderTable hh = font.getHorizontalHeader();
        if (hh == null) {
            throw new IOException("hhead is mandatory");
        }
        MaximumProfileTable maxp = font.getMaximumProfile();
        if (maxp == null) {
            throw new IOException("maxp is mandatory");
        }
        PostScriptTable post = font.getPostScript();
        if (post == null && !this.isEmbedded) {
            throw new IOException("post is mandatory");
        }
        if (!isPostScript) {
            IndexToLocationTable loc = font.getIndexToLocation();
            if (loc == null) {
                throw new IOException("loca is mandatory");
            }
            if (font.getGlyph() == null) {
                throw new IOException("glyf is mandatory");
            }
        }
        if (font.getNaming() == null && !this.isEmbedded) {
            throw new IOException("name is mandatory");
        }
        if (font.getHorizontalMetrics() == null) {
            throw new IOException("hmtx is mandatory");
        }
        if (!this.isEmbedded && font.getCmap() == null) {
            throw new IOException("cmap is mandatory");
        }
    }

    protected boolean allowCFF() {
        return false;
    }

    private TTFTable readTableDirectory(TrueTypeFont font, TTFDataStream raf) throws IOException {
        TTFTable table;
        String tag;
        switch (tag = raf.readString(4)) {
            case "cmap": {
                table = new CmapTable(font);
                break;
            }
            case "glyf": {
                table = new GlyphTable(font);
                break;
            }
            case "head": {
                table = new HeaderTable(font);
                break;
            }
            case "hhea": {
                table = new HorizontalHeaderTable(font);
                break;
            }
            case "hmtx": {
                table = new HorizontalMetricsTable(font);
                break;
            }
            case "loca": {
                table = new IndexToLocationTable(font);
                break;
            }
            case "maxp": {
                table = new MaximumProfileTable(font);
                break;
            }
            case "name": {
                table = new NamingTable(font);
                break;
            }
            case "OS/2": {
                table = new OS2WindowsMetricsTable(font);
                break;
            }
            case "post": {
                table = new PostScriptTable(font);
                break;
            }
            case "DSIG": {
                table = new DigitalSignatureTable(font);
                break;
            }
            case "kern": {
                table = new KerningTable(font);
                break;
            }
            case "vhea": {
                table = new VerticalHeaderTable(font);
                break;
            }
            case "vmtx": {
                table = new VerticalMetricsTable(font);
                break;
            }
            case "VORG": {
                table = new VerticalOriginTable(font);
                break;
            }
            default: {
                table = this.readTable(font, tag);
            }
        }
        table.setTag(tag);
        table.setCheckSum(raf.readUnsignedInt());
        table.setOffset(raf.readUnsignedInt());
        table.setLength(raf.readUnsignedInt());
        if (table.getLength() == 0L && !tag.equals("glyf")) {
            return null;
        }
        return table;
    }

    protected TTFTable readTable(TrueTypeFont font, String tag) {
        return new TTFTable(font);
    }
}

