/*
 * Decompiled with CFR 0.152.
 */
package com.nh.micro.dao.mapper;

import com.nh.micro.dao.mapper.MicroPageInfo;
import com.nh.micro.orm.MicroBeanMapUtil;
import com.nh.micro.orm.MicroTableName;
import com.nh.micro.rule.engine.core.GroovyExecUtil;
import com.nh.micro.template.IdHolder;
import com.nh.micro.template.MicroServiceTemplateSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MicroMapperTemplate<T>
extends MicroServiceTemplateSupport {
    private static final String MICRO_DB_NULL = "MICRO_DB_NULL";
    public Class defaultClass;

    public Class getDefaultClass() {
        return this.defaultClass;
    }

    public void setDefaultClass(Class defaultClass) {
        this.defaultClass = defaultClass;
    }

    public MicroMapperTemplate() {
    }

    public MicroMapperTemplate(String dbName) {
        super(dbName);
    }

    public MicroMapperTemplate getMicroMapperTemplate() {
        return this;
    }

    public List getInfoListAllMapper(Object example, String orderStr) throws Exception {
        return this.getInfoListAllMapper4Class(example, orderStr, this.defaultClass, this.defaultClass);
    }

    public List getInfoListAllMapper4Class(Object example, String orderStr, Class inClass, Class outClass) throws Exception {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        Map paramMap = new HashMap();
        if (example != null) {
            paramMap = MicroBeanMapUtil.beanToMap((Object)example);
        }
        HashMap<String, String> sortMap = new HashMap<String, String>();
        if (orderStr != null && !"".equals(orderStr)) {
            sortMap.put("cusSort", orderStr);
        }
        List tempList = this.getInfoListAllService(paramMap, tableName, sortMap);
        ArrayList<Object> retList = new ArrayList<Object>();
        for (Map rowMap : tempList) {
            retList.add(MicroBeanMapUtil.mapToBean((Map)rowMap, (Class)outClass));
        }
        return retList;
    }

    public List getInfoList4PageMapper(Object example, MicroPageInfo pageInfo) throws Exception {
        return this.getInfoList4PageMapper4Class(example, pageInfo, this.defaultClass, this.defaultClass);
    }

    public List getInfoList4PageMapper4Class(Object example, MicroPageInfo pageInfo, Class inClass, Class outClass) throws Exception {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        Map paramMap = new HashMap();
        if (example != null) {
            paramMap = MicroBeanMapUtil.beanToMap((Object)example);
        }
        HashMap<String, String> sortMap = new HashMap<String, String>();
        String orderStr = pageInfo.getOrderStr();
        if (orderStr != null && !"".equals(orderStr)) {
            sortMap.put("cusSort", orderStr);
        }
        if (pageInfo != null) {
            sortMap.put("page", pageInfo.getPageNo().toString());
            sortMap.put("rows", pageInfo.getPageRows().toString());
        }
        Map tempMap = this.getInfoList4PageService(paramMap, tableName, sortMap);
        String total = String.valueOf(tempMap.get("total"));
        if (pageInfo != null) {
            pageInfo.setTotal(Long.valueOf(total));
        }
        List tempList = (List)tempMap.get("rows");
        ArrayList<Object> retList = new ArrayList<Object>();
        for (Map rowMap : tempList) {
            retList.add(MicroBeanMapUtil.mapToBean((Map)rowMap, (Class)outClass));
        }
        return retList;
    }

    public Integer createInfoMapper(Object example) throws Exception {
        return this.createInfoMapper4Class(example, null, null, this.defaultClass);
    }

    public Integer createInfoMapper4Cus(Object example, String cusCol, String cusValue) throws Exception {
        return this.createInfoMapper4Class(example, cusCol, cusValue, this.defaultClass);
    }

    public Integer createInfoMapper4Class(Object example, String cusCol, String cusValue, Class inClass) throws Exception {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        Map paramMap = new HashMap();
        if (example != null) {
            paramMap = MicroBeanMapUtil.beanToMap((Object)example);
        }
        String tempKeyId = this.calcuIdKey();
        boolean setIdFlag = false;
        if (paramMap.get(tempKeyId) == null) {
            setIdFlag = true;
        }
        Integer status = this.createInfoService(paramMap, tableName, cusCol, cusValue);
        if (setIdFlag && example != null) {
            Object id = paramMap.get(tempKeyId);
            Map mappingInfo = MicroBeanMapUtil.getKeyMap((Class)inClass);
            String fieldName = (String)mappingInfo.get(tempKeyId);
            MicroBeanMapUtil.setBeanProperty((Object)example, (String)fieldName, (Object)id.toString());
        }
        return status;
    }

    public List getNullFlagList(Object example) {
        Class<?> cls = example.getClass();
        Field[] fields = cls.getDeclaredFields();
        if (fields == null) {
            return null;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("microNullFlagList")) continue;
            try {
                List retList = (List)fields[i].get(example);
                return retList;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void flagNull2Map(Map paramMap, List<String> flagList) {
        if (flagList == null) {
            return;
        }
        for (String key : flagList) {
            if (!paramMap.containsKey(key)) continue;
            paramMap.put(key, MICRO_DB_NULL);
        }
    }

    public Integer updateInfoMapper(Object example) throws Exception {
        return this.updateInfoMapper4Class(example, null, null, this.defaultClass);
    }

    public Integer updateInfoMapper4Cus(Object example, String cusCondition, String cusSetStr) throws Exception {
        return this.updateInfoMapper4Class(example, cusCondition, cusSetStr, this.defaultClass);
    }

    public Integer updateInfoMapper4Class(Object example, String cusCondition, String cusSetStr, Class inClass) throws Exception {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        Map paramMap = new HashMap();
        if (example != null) {
            paramMap = MicroBeanMapUtil.beanToMap((Object)example);
        }
        List flagList = this.getNullFlagList(example);
        MicroMapperTemplate.flagNull2Map(paramMap, flagList);
        Integer status = this.updateInfoService(paramMap, tableName, cusCondition, cusSetStr);
        return status;
    }

    public Integer delInfoMapper(Object example) throws Exception {
        return this.delInfoMapper4Class(example, this.defaultClass);
    }

    public Integer delInfoMapper4Class(Object example, Class inClass) throws Exception {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        Map paramMap = new HashMap();
        if (example != null) {
            paramMap = MicroBeanMapUtil.beanToMap((Object)example);
        }
        Integer status = this.delInfoService(paramMap, tableName);
        return status;
    }

    public Integer delInfoByIdMapper(String id) {
        return this.delInfoByIdMapper4Class(id, this.defaultClass);
    }

    public Integer delInfoByIdMapper4Class(String id, Class inClass) {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        HashMap paramMap = new HashMap();
        Integer status = this.delInfoByIdService(id, tableName);
        return status;
    }

    public Integer delInfoByBizIdMapper(String bizId, String bizCol) {
        return this.delInfoByBizIdMapper4Class(bizId, bizCol, this.defaultClass);
    }

    public Integer delInfoByBizIdMapper4Class(String bizId, String bizCol, Class inClass) {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        HashMap paramMap = new HashMap();
        Integer status = this.delInfoByBizIdService(bizId, tableName, bizCol);
        return status;
    }

    public T getInfoByIdMapper(String id) throws Exception {
        return this.getInfoByIdMapper4Class(id, this.defaultClass, this.defaultClass);
    }

    public T getInfoByIdMapper4Class(String id, Class inClass, Class outClass) throws Exception {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        Map tempMap = this.getInfoByIdService(id, tableName);
        Object retObj = MicroBeanMapUtil.mapToBean((Map)tempMap, (Class)outClass);
        return (T)retObj;
    }

    public T getInfoByBizIdMapper(String bizId, String bizCol) throws Exception {
        return this.getInfoByBizIdMapper4Class(bizId, bizCol, this.defaultClass, this.defaultClass);
    }

    public T getInfoByBizIdMapper4Class(String bizId, String bizCol, Class inClass, Class outClass) throws Exception {
        MicroTableName microTableName = inClass.getAnnotation(MicroTableName.class);
        if (microTableName == null) {
            throw new RuntimeException("table name is null");
        }
        String tableName = microTableName.name();
        Map tempMap = this.getInfoByBizIdService(bizId, tableName, bizCol);
        Object retObj = MicroBeanMapUtil.mapToBean((Map)tempMap, (Class)outClass);
        return (T)retObj;
    }

    public Integer updateInfoServiceByOrm(String groovyName, String methodName, Object ... paramArray) throws Exception {
        ArrayList placeList = new ArrayList();
        String sql = (String)GroovyExecUtil.execGroovyRetObj((String)groovyName, (String)methodName, (Object[])new Object[]{paramArray, placeList});
        return this.updateInfoServiceBySql(sql, placeList);
    }

    public List getInfoList4PageServiceByOrm(String countSql, List countPlaceList, String sql, List placeList, MicroPageInfo pageInfo, Class outClass) throws Exception {
        HashMap<String, String> sortMap = new HashMap<String, String>();
        String orderStr = pageInfo.getOrderStr();
        if (orderStr != null && !"".equals(orderStr)) {
            sortMap.put("cusSort", orderStr);
        }
        if (pageInfo != null) {
            sortMap.put("page", pageInfo.getPageNo().toString());
            sortMap.put("rows", pageInfo.getPageRows().toString());
        }
        Map tempMap = this.getInfoList4PageServiceBySql(countSql, countPlaceList, sql, placeList, sortMap);
        String total = String.valueOf(tempMap.get("total"));
        if (pageInfo != null) {
            pageInfo.setTotal(Long.valueOf(total));
        }
        List tempList = (List)tempMap.get("rows");
        List<Object> retList = new ArrayList();
        if (outClass != null) {
            for (Map rowMap : tempList) {
                retList.add(MicroBeanMapUtil.mapToBean((Map)rowMap, (Class)outClass));
            }
        } else {
            retList = tempList;
        }
        return retList;
    }

    public List getInfoListAllServiceByOrm(String sql, List placeList, Class outClass) throws Exception {
        List tempList = this.getInfoListAllServiceBySql(sql, placeList);
        List<Object> retList = new ArrayList();
        if (outClass != null) {
            for (Map rowMap : tempList) {
                retList.add(MicroBeanMapUtil.mapToBean((Map)rowMap, (Class)outClass));
            }
        } else {
            retList = tempList;
        }
        return retList;
    }

    public Object getSingleInfoServiceByOrm(String sql, List placeList, Class outClass) throws Exception {
        Map retMap = this.getSingleInfoService(sql, placeList);
        return MicroBeanMapUtil.mapToBean((Map)retMap, (Class)outClass);
    }

    public Integer createInfoServiceByOrm(String sql, List placeList, IdHolder idHolder) throws Exception {
        return this.createInfoServiceBySql(sql, placeList, idHolder);
    }

    public Object execServiceByGroovy(String groovyName, String methodName, Class outClass, boolean listFlag, Object ... paramArray) throws Exception {
        ArrayList placeList = new ArrayList();
        String sql = (String)GroovyExecUtil.execGroovyRetObj((String)groovyName, (String)methodName, (Object[])new Object[]{paramArray, placeList});
        String type = this.checkSqlType(sql);
        if (type.equals("select")) {
            MicroPageInfo pageInfo = this.checkPage(paramArray);
            if (pageInfo == null) {
                if (listFlag) {
                    return this.getInfoListAllServiceByOrm(sql, placeList, outClass);
                }
                return this.getSingleInfoServiceByOrm(sql, placeList, outClass);
            }
            String countSql = "select count(1) from ( " + sql + " )";
            String dbType = this.calcuDbType();
            if (dbType != null && !dbType.equals("oracle")) {
                countSql = countSql + "  as micro_total_alias";
            }
            return this.getInfoList4PageServiceByOrm(countSql, placeList, sql, placeList, pageInfo, outClass);
        }
        if (type.equals("insert")) {
            IdHolder idHolder = this.checkIdHolder(paramArray);
            return this.createInfoServiceBySql(sql, placeList, idHolder);
        }
        if (type.equals("update") || type.equals("delete")) {
            return this.updateInfoServiceBySql(sql, placeList);
        }
        return null;
    }

    private String checkSqlType(String sql) {
        int indexSel = sql.toLowerCase().indexOf("select");
        int indexUpdate = sql.toLowerCase().indexOf("update");
        int indexDel = sql.toLowerCase().indexOf("delete");
        int indexInsert = sql.toLowerCase().indexOf("insert");
        int[] indexArray = new int[]{indexSel, indexUpdate, indexDel, indexInsert};
        Arrays.sort(indexArray);
        int indexMix = -1;
        for (int index : indexArray) {
            if (index < 0) continue;
            indexMix = index;
            break;
        }
        String type = "ddl";
        if (indexSel >= 0 && indexSel == indexMix) {
            type = "select";
        } else if (indexUpdate >= 0 && indexUpdate == indexMix) {
            type = "update";
        } else if (indexDel >= 0 && indexDel == indexMix) {
            type = "delete";
        } else if (indexInsert >= 0 && indexInsert == indexMix) {
            type = "insert";
        }
        return type;
    }

    private MicroPageInfo checkPage(Object[] args) {
        if (args == null) {
            return null;
        }
        for (Object obj : args) {
            if (!(obj instanceof MicroPageInfo)) continue;
            return (MicroPageInfo)obj;
        }
        return null;
    }

    private IdHolder checkIdHolder(Object[] args) {
        if (args == null) {
            return null;
        }
        for (Object obj : args) {
            if (!(obj instanceof IdHolder)) continue;
            return (IdHolder)obj;
        }
        return null;
    }
}

